/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.fake.source;

import com.google.auto.service.AutoService;
import java.util.Collections;
import org.apache.seatunnel.api.common.JobContext;
import org.apache.seatunnel.api.common.SeaTunnelAPIErrorCode;
import org.apache.seatunnel.api.source.Boundedness;
import org.apache.seatunnel.api.source.SeaTunnelSource;
import org.apache.seatunnel.api.source.SourceReader;
import org.apache.seatunnel.api.source.SourceSplitEnumerator;
import org.apache.seatunnel.api.source.SupportColumnProjection;
import org.apache.seatunnel.api.source.SupportParallelism;
import org.apache.seatunnel.api.table.catalog.CatalogTableUtil;
import org.apache.seatunnel.api.table.type.SeaTunnelRow;
import org.apache.seatunnel.api.table.type.SeaTunnelRowType;
import org.apache.seatunnel.common.config.CheckConfigUtil;
import org.apache.seatunnel.common.config.CheckResult;
import org.apache.seatunnel.common.constants.JobMode;
import org.apache.seatunnel.common.constants.PluginType;
import org.apache.seatunnel.common.exception.SeaTunnelErrorCode;
import org.apache.seatunnel.connectors.seatunnel.fake.config.FakeConfig;
import org.apache.seatunnel.connectors.seatunnel.fake.exception.FakeConnectorException;
import org.apache.seatunnel.connectors.seatunnel.fake.source.FakeSourceReader;
import org.apache.seatunnel.connectors.seatunnel.fake.source.FakeSourceSplit;
import org.apache.seatunnel.connectors.seatunnel.fake.source.FakeSourceSplitEnumerator;
import org.apache.seatunnel.connectors.seatunnel.fake.state.FakeSourceState;
import org.apache.seatunnel.shade.com.typesafe.config.Config;

@AutoService(value={SeaTunnelSource.class})
public class FakeSource
implements SeaTunnelSource<SeaTunnelRow, FakeSourceSplit, FakeSourceState>,
SupportParallelism,
SupportColumnProjection {
    private JobContext jobContext;
    private SeaTunnelRowType rowType;
    private FakeConfig fakeConfig;

    public Boundedness getBoundedness() {
        return JobMode.BATCH.equals((Object)this.jobContext.getJobMode()) ? Boundedness.BOUNDED : Boundedness.UNBOUNDED;
    }

    public SeaTunnelRowType getProducedType() {
        return this.rowType;
    }

    public SourceSplitEnumerator<FakeSourceSplit, FakeSourceState> createEnumerator(SourceSplitEnumerator.Context<FakeSourceSplit> enumeratorContext) throws Exception {
        return new FakeSourceSplitEnumerator(enumeratorContext, this.fakeConfig, Collections.emptySet());
    }

    public SourceSplitEnumerator<FakeSourceSplit, FakeSourceState> restoreEnumerator(SourceSplitEnumerator.Context<FakeSourceSplit> enumeratorContext, FakeSourceState checkpointState) throws Exception {
        return new FakeSourceSplitEnumerator(enumeratorContext, this.fakeConfig, checkpointState.getAssignedSplits());
    }

    public SourceReader<SeaTunnelRow, FakeSourceSplit> createReader(SourceReader.Context readerContext) throws Exception {
        return new FakeSourceReader(readerContext, this.rowType, this.fakeConfig);
    }

    public String getPluginName() {
        return "FakeSource";
    }

    public void prepare(Config pluginConfig) {
        CheckResult result = CheckConfigUtil.checkAllExists((Config)pluginConfig, (String[])new String[]{CatalogTableUtil.SCHEMA.key()});
        if (!result.isSuccess()) {
            throw new FakeConnectorException((SeaTunnelErrorCode)SeaTunnelAPIErrorCode.CONFIG_VALIDATION_FAILED, String.format("PluginName: %s, PluginType: %s, Message: %s", this.getPluginName(), PluginType.SOURCE, result.getMsg()));
        }
        this.rowType = CatalogTableUtil.buildWithConfig((Config)pluginConfig).getSeaTunnelRowType();
        this.fakeConfig = FakeConfig.buildWithConfig(pluginConfig);
    }

    public void setJobContext(JobContext jobContext) {
        this.jobContext = jobContext;
    }
}

