/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.util.graph;

import com.hazelcast.internal.util.graph.Graph;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;

public class BronKerboschCliqueFinder<V> {
    private final Graph<V> graph;
    private final long nanos;
    private boolean timeLimitReached;
    private List<Set<V>> maximumCliques;

    public BronKerboschCliqueFinder(Graph<V> graph, long timeout, TimeUnit unit) {
        this.graph = Objects.requireNonNull(graph, "Graph cannot be null");
        if (timeout < 1L) {
            throw new IllegalArgumentException("Invalid timeout, must be positive!");
        }
        this.nanos = unit.toNanos(timeout);
    }

    public BronKerboschCliqueFinder(Graph<V> graph) {
        this(graph, Long.MAX_VALUE, TimeUnit.NANOSECONDS);
    }

    public Collection<Set<V>> computeMaxCliques() {
        this.lazyRun();
        return this.maximumCliques;
    }

    public boolean isTimeLimitReached() {
        return this.timeLimitReached;
    }

    private void lazyRun() {
        long nanosTimeLimit;
        if (this.maximumCliques != null) {
            return;
        }
        this.maximumCliques = new ArrayList<Set<V>>();
        try {
            nanosTimeLimit = Math.addExact(System.nanoTime(), this.nanos);
        }
        catch (ArithmeticException e) {
            nanosTimeLimit = Long.MAX_VALUE;
        }
        this.findCliques(new HashSet(), new HashSet<V>(this.graph.vertexSet()), new HashSet(), nanosTimeLimit);
    }

    private void findCliques(Collection<V> potentialClique, Collection<V> candidates, Collection<V> alreadyFound, long nanosTimeLimit) {
        for (V v : alreadyFound) {
            if (!candidates.stream().allMatch(c -> this.graph.containsEdge(v, c))) continue;
            return;
        }
        Iterator<V> it = candidates.iterator();
        while (it.hasNext()) {
            if (nanosTimeLimit - System.nanoTime() < 0L) {
                this.timeLimitReached = true;
                return;
            }
            V candidate = it.next();
            it.remove();
            potentialClique.add(candidate);
            Collection<V> newCandidates = this.populate(candidates, candidate);
            Collection<V> newAlreadyFound = this.populate(alreadyFound, candidate);
            if (newCandidates.isEmpty() && newAlreadyFound.isEmpty()) {
                this.addMaxClique(potentialClique);
            } else {
                this.findCliques(potentialClique, newCandidates, newAlreadyFound, nanosTimeLimit);
            }
            alreadyFound.add(candidate);
            potentialClique.remove(candidate);
        }
    }

    private Collection<V> populate(Collection<V> candidates, V candidate) {
        HashSet<V> newCandidates = new HashSet<V>();
        for (V newCandidate : candidates) {
            if (!this.graph.containsEdge(candidate, newCandidate)) continue;
            newCandidates.add(newCandidate);
        }
        return newCandidates;
    }

    private void addMaxClique(Collection<V> potentialClique) {
        if (this.maximumCliques.isEmpty() || potentialClique.size() == this.maximumCliques.get(0).size()) {
            this.maximumCliques.add(new HashSet<V>(potentialClique));
        } else if (potentialClique.size() > this.maximumCliques.get(0).size()) {
            this.maximumCliques.clear();
            this.maximumCliques.add(new HashSet<V>(potentialClique));
        }
    }
}

