/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.config;

import com.hazelcast.internal.util.Preconditions;
import com.hazelcast.jet.config.JetConfigDataSerializerHook;
import com.hazelcast.jet.config.ResourceType;
import com.hazelcast.jet.impl.util.ReflectionUtils;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.spi.annotation.PrivateApi;
import java.io.IOException;
import java.net.URL;
import java.util.Objects;
import javax.annotation.Nonnull;

@PrivateApi
public class ResourceConfig
implements IdentifiedDataSerializable {
    private URL url;
    private String id;
    private ResourceType resourceType;

    ResourceConfig() {
    }

    ResourceConfig(@Nonnull URL url, @Nonnull String id, @Nonnull ResourceType resourceType) {
        Preconditions.checkNotNull(url, "url");
        Preconditions.checkNotNull(resourceType, "resourceType");
        Preconditions.checkHasText(id, "id cannot be null or empty");
        this.url = url;
        this.id = id;
        this.resourceType = resourceType;
    }

    ResourceConfig(@Nonnull Class<?> clazz) {
        Preconditions.checkNotNull(clazz, "clazz");
        String id = ReflectionUtils.toClassResourceId(clazz.getName());
        ClassLoader cl = clazz.getClassLoader();
        if (cl == null) {
            throw new IllegalArgumentException(clazz.getName() + ".getClassLoader() returned null, cannot access the class resource. You may have added a JDK class that is loaded by the bootstrap classloader. There is no need to add JDK classes to the job configuration.");
        }
        URL url = cl.getResource(id);
        if (url == null) {
            throw new IllegalArgumentException("The classloader of " + clazz.getName() + " couldn't resolve the resource URL of " + id);
        }
        this.id = id;
        this.url = url;
        this.resourceType = ResourceType.CLASS;
    }

    @Nonnull
    public URL getUrl() {
        return this.url;
    }

    @Nonnull
    public String getId() {
        return this.id;
    }

    @Nonnull
    public ResourceType getResourceType() {
        return this.resourceType;
    }

    public String toString() {
        return "ResourceConfig{url=" + this.url + ", id='" + this.id + '\'' + ", resourceType=" + (Object)((Object)this.resourceType) + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResourceConfig that = (ResourceConfig)o;
        return this.url.toString().equals(that.url.toString()) && this.id.equals(that.id) && this.resourceType == that.resourceType;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.url, this.id, this.resourceType});
    }

    @Override
    public int getFactoryId() {
        return JetConfigDataSerializerHook.FACTORY_ID;
    }

    @Override
    public int getClassId() {
        return 2;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeString(this.id);
        out.writeShort(this.resourceType.getId());
        out.writeObject(this.url);
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.id = in.readString();
        this.resourceType = ResourceType.getById(in.readShort());
        this.url = (URL)in.readObject();
    }
}

