/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.engine.imap.storage.file.config;

import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.seatunnel.engine.imap.storage.api.exception.IMapStorageException;

public abstract class AbstractConfiguration {
    public static final String BLOCK_SIZE = "block.size";
    protected static final String HDFS_IMPL_KEY = "impl";
    private Long blockSize = 0x100000L;

    public Long getBlockSize() {
        return this.blockSize;
    }

    public void setBlockSize(Long blockSize) {
        this.blockSize = blockSize;
    }

    void checkConfiguration(Map<String, Object> config, String ... keys) {
        for (String key : keys) {
            if (config.containsKey(key) && null != config.get(key)) continue;
            throw new IllegalArgumentException(key + " is required");
        }
    }

    public abstract Configuration buildConfiguration(Map<String, Object> var1) throws IMapStorageException;

    void setExtraConfiguration(Configuration hadoopConf, Map<String, Object> config, String prefix) {
        config.forEach((k, v) -> {
            if (config.containsKey(BLOCK_SIZE)) {
                this.setBlockSize(Long.parseLong(config.get(BLOCK_SIZE).toString()));
            }
            if (k.startsWith(prefix)) {
                hadoopConf.set(k, String.valueOf(v));
            }
        });
    }
}

