/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.engine.server.log;

import com.hazelcast.internal.ascii.TextCommandService;
import com.hazelcast.internal.ascii.rest.HttpCommandProcessor;
import com.hazelcast.internal.ascii.rest.HttpPostCommand;
import com.hazelcast.internal.ascii.rest.HttpPostCommandProcessor;
import com.hazelcast.internal.ascii.rest.HttpStatusCode;
import com.hazelcast.internal.json.JsonObject;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.config.Configurator;

public class Log4j2HttpPostCommandProcessor
extends HttpCommandProcessor<HttpPostCommand> {
    private final HttpPostCommandProcessor original;

    public Log4j2HttpPostCommandProcessor(TextCommandService textCommandService) {
        this(textCommandService, new HttpPostCommandProcessor(textCommandService));
    }

    public Log4j2HttpPostCommandProcessor(TextCommandService textCommandService, HttpPostCommandProcessor httpPostCommandProcessor) {
        super(textCommandService, textCommandService.getNode().getLogger(Log4j2HttpPostCommandProcessor.class));
        this.original = httpPostCommandProcessor;
    }

    @Override
    public void handleRejection(HttpPostCommand request) {
        this.handle(request);
    }

    @Override
    public void handle(HttpPostCommand request) {
        String uri = request.getURI();
        if (uri.startsWith("/hazelcast/rest/log-level")) {
            this.setLoggerLevel(request);
        } else if (uri.startsWith("/hazelcast/rest/log-level/reset")) {
            this.prepareResponse(HttpStatusCode.SC_500, request, "Reset logger level endpoint disabled!");
            this.textCommandService.sendResponse(request);
        } else {
            this.original.handle(request);
        }
    }

    private void setLoggerLevel(HttpPostCommand request) {
        try {
            String[] params = this.decodeParamsAndAuthenticate(request, 4);
            String logger = params[2];
            String level = params[3];
            if ("root".equals(logger)) {
                Configurator.setRootLevel(Level.getLevel(level));
            } else {
                Configurator.setLevel(logger, Level.getLevel(level));
            }
            this.prepareResponse(request, new JsonObject().add("status", "SUCCESS"));
        }
        catch (Throwable e) {
            this.prepareResponse(HttpStatusCode.SC_500, request, Log4j2HttpPostCommandProcessor.exceptionResponse(e));
        }
        this.textCommandService.sendResponse(request);
    }
}

