/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.serialization.impl.compact;

import com.hazelcast.internal.nio.BufferObjectDataInput;
import com.hazelcast.internal.nio.BufferObjectDataOutput;
import com.hazelcast.internal.serialization.impl.compact.CompactStreamSerializer;
import com.hazelcast.internal.serialization.impl.compact.DefaultCompactReader;
import com.hazelcast.internal.serialization.impl.compact.DefaultCompactWriter;
import com.hazelcast.internal.serialization.impl.compact.Schema;
import com.hazelcast.nio.serialization.GenericRecord;
import com.hazelcast.nio.serialization.GenericRecordBuilder;
import com.hazelcast.nio.serialization.HazelcastSerializationException;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class SerializingGenericRecordBuilder
implements GenericRecordBuilder {
    private final DefaultCompactWriter defaultCompactWriter;
    private final CompactStreamSerializer serializer;
    private final Schema schema;
    private final Function<byte[], BufferObjectDataInput> bufferObjectDataInputFunc;
    private final Set<String> writtenFields = new HashSet<String>();

    public SerializingGenericRecordBuilder(CompactStreamSerializer serializer, Schema schema, Function<byte[], BufferObjectDataInput> bufferObjectDataInputFunc, Supplier<BufferObjectDataOutput> bufferObjectDataOutputSupplier) {
        this.serializer = serializer;
        this.schema = schema;
        this.defaultCompactWriter = new DefaultCompactWriter(serializer, bufferObjectDataOutputSupplier.get(), schema, false);
        this.bufferObjectDataInputFunc = bufferObjectDataInputFunc;
    }

    @Override
    @Nonnull
    public GenericRecord build() {
        Set<String> fieldNames = this.schema.getFieldNames();
        for (String fieldName : fieldNames) {
            if (this.writtenFields.contains(fieldName)) continue;
            throw new HazelcastSerializationException("Found an unset field " + fieldName + ". All the fields must be set before build");
        }
        this.defaultCompactWriter.end();
        byte[] bytes = this.defaultCompactWriter.toByteArray();
        return new DefaultCompactReader(this.serializer, this.bufferObjectDataInputFunc.apply(bytes), this.schema, null, false);
    }

    @Override
    @Nonnull
    public GenericRecordBuilder setInt32(@Nonnull String fieldName, int value) {
        this.checkIfAlreadyWritten(fieldName);
        this.defaultCompactWriter.writeInt32(fieldName, value);
        return this;
    }

    @Override
    @Nonnull
    public GenericRecordBuilder setInt64(@Nonnull String fieldName, long value) {
        this.checkIfAlreadyWritten(fieldName);
        this.defaultCompactWriter.writeInt64(fieldName, value);
        return this;
    }

    @Override
    @Nonnull
    public GenericRecordBuilder setString(@Nonnull String fieldName, String value) {
        this.checkIfAlreadyWritten(fieldName);
        this.defaultCompactWriter.writeString(fieldName, value);
        return this;
    }

    @Override
    @Nonnull
    public GenericRecordBuilder setBoolean(@Nonnull String fieldName, boolean value) {
        this.checkIfAlreadyWritten(fieldName);
        this.defaultCompactWriter.writeBoolean(fieldName, value);
        return this;
    }

    @Override
    @Nonnull
    public GenericRecordBuilder setInt8(@Nonnull String fieldName, byte value) {
        this.checkIfAlreadyWritten(fieldName);
        this.defaultCompactWriter.writeInt8(fieldName, value);
        return this;
    }

    @Override
    @Nonnull
    public GenericRecordBuilder setChar(@Nonnull String fieldName, char value) {
        throw new UnsupportedOperationException("Compact format does not support writing a char field");
    }

    @Override
    @Nonnull
    public GenericRecordBuilder setFloat64(@Nonnull String fieldName, double value) {
        this.checkIfAlreadyWritten(fieldName);
        this.defaultCompactWriter.writeFloat64(fieldName, value);
        return this;
    }

    @Override
    @Nonnull
    public GenericRecordBuilder setFloat32(@Nonnull String fieldName, float value) {
        this.checkIfAlreadyWritten(fieldName);
        this.defaultCompactWriter.writeFloat32(fieldName, value);
        return this;
    }

    @Override
    @Nonnull
    public GenericRecordBuilder setInt16(@Nonnull String fieldName, short value) {
        this.checkIfAlreadyWritten(fieldName);
        this.defaultCompactWriter.writeInt16(fieldName, value);
        return this;
    }

    @Override
    @Nonnull
    public GenericRecordBuilder setNullableBoolean(@Nonnull String fieldName, @Nullable Boolean value) {
        this.checkIfAlreadyWritten(fieldName);
        this.defaultCompactWriter.writeNullableBoolean(fieldName, value);
        return this;
    }

    @Override
    @Nonnull
    public GenericRecordBuilder setNullableInt8(@Nonnull String fieldName, @Nullable Byte value) {
        this.checkIfAlreadyWritten(fieldName);
        this.defaultCompactWriter.writeNullableInt8(fieldName, value);
        return this;
    }

    @Override
    @Nonnull
    public GenericRecordBuilder setNullableFloat64(@Nonnull String fieldName, @Nullable Double value) {
        this.checkIfAlreadyWritten(fieldName);
        this.defaultCompactWriter.writeNullableFloat64(fieldName, value);
        return this;
    }

    @Override
    @Nonnull
    public GenericRecordBuilder setNullableFloat32(@Nonnull String fieldName, @Nullable Float value) {
        this.checkIfAlreadyWritten(fieldName);
        this.defaultCompactWriter.writeNullableFloat32(fieldName, value);
        return this;
    }

    @Override
    @Nonnull
    public GenericRecordBuilder setNullableInt32(@Nonnull String fieldName, @Nullable Integer value) {
        this.checkIfAlreadyWritten(fieldName);
        this.defaultCompactWriter.writeNullableInt32(fieldName, value);
        return this;
    }

    @Override
    @Nonnull
    public GenericRecordBuilder setNullableInt64(@Nonnull String fieldName, @Nullable Long value) {
        this.checkIfAlreadyWritten(fieldName);
        this.defaultCompactWriter.writeNullableInt64(fieldName, value);
        return this;
    }

    @Override
    @Nonnull
    public GenericRecordBuilder setNullableInt16(@Nonnull String fieldName, @Nullable Short value) {
        this.checkIfAlreadyWritten(fieldName);
        this.defaultCompactWriter.writeNullableInt16(fieldName, value);
        return this;
    }

    @Override
    @Nonnull
    public GenericRecordBuilder setDecimal(@Nonnull String fieldName, @Nullable BigDecimal value) {
        this.checkIfAlreadyWritten(fieldName);
        this.defaultCompactWriter.writeDecimal(fieldName, value);
        return this;
    }

    @Override
    @Nonnull
    public GenericRecordBuilder setTime(@Nonnull String fieldName, @Nullable LocalTime value) {
        this.checkIfAlreadyWritten(fieldName);
        this.defaultCompactWriter.writeTime(fieldName, value);
        return this;
    }

    @Override
    @Nonnull
    public GenericRecordBuilder setDate(@Nonnull String fieldName, @Nullable LocalDate value) {
        this.checkIfAlreadyWritten(fieldName);
        this.defaultCompactWriter.writeDate(fieldName, value);
        return this;
    }

    @Override
    @Nonnull
    public GenericRecordBuilder setTimestamp(@Nonnull String fieldName, @Nullable LocalDateTime value) {
        this.checkIfAlreadyWritten(fieldName);
        this.defaultCompactWriter.writeTimestamp(fieldName, value);
        return this;
    }

    @Override
    @Nonnull
    public GenericRecordBuilder setTimestampWithTimezone(@Nonnull String fieldName, @Nullable OffsetDateTime value) {
        this.checkIfAlreadyWritten(fieldName);
        this.defaultCompactWriter.writeTimestampWithTimezone(fieldName, value);
        return this;
    }

    @Override
    @Nonnull
    public GenericRecordBuilder setGenericRecord(@Nonnull String fieldName, @Nullable GenericRecord value) {
        this.checkIfAlreadyWritten(fieldName);
        this.defaultCompactWriter.writeGenericRecord(fieldName, value);
        return this;
    }

    @Override
    @Nonnull
    public GenericRecordBuilder setArrayOfGenericRecord(@Nonnull String fieldName, @Nullable GenericRecord[] value) {
        this.checkIfAlreadyWritten(fieldName);
        this.defaultCompactWriter.writeArrayOfGenericRecord(fieldName, value);
        return this;
    }

    @Override
    @Nonnull
    public GenericRecordBuilder setArrayOfInt8(@Nonnull String fieldName, @Nullable byte[] value) {
        this.checkIfAlreadyWritten(fieldName);
        this.defaultCompactWriter.writeArrayOfInt8(fieldName, value);
        return this;
    }

    @Override
    @Nonnull
    public GenericRecordBuilder setArrayOfBoolean(@Nonnull String fieldName, @Nullable boolean[] value) {
        this.checkIfAlreadyWritten(fieldName);
        this.defaultCompactWriter.writeArrayOfBoolean(fieldName, value);
        return this;
    }

    @Override
    @Nonnull
    public GenericRecordBuilder setArrayOfChar(@Nonnull String fieldName, @Nullable char[] value) {
        throw new UnsupportedOperationException("Compact format does not support writing an array of chars field");
    }

    @Override
    @Nonnull
    public GenericRecordBuilder setArrayOfInt32(@Nonnull String fieldName, @Nullable int[] value) {
        this.checkIfAlreadyWritten(fieldName);
        this.defaultCompactWriter.writeArrayOfInt32(fieldName, value);
        return this;
    }

    @Override
    @Nonnull
    public GenericRecordBuilder setArrayOfInt64(@Nonnull String fieldName, @Nullable long[] value) {
        this.checkIfAlreadyWritten(fieldName);
        this.defaultCompactWriter.writeArrayOfInt64(fieldName, value);
        return this;
    }

    @Override
    @Nonnull
    public GenericRecordBuilder setArrayOfFloat64(@Nonnull String fieldName, @Nullable double[] value) {
        this.checkIfAlreadyWritten(fieldName);
        this.defaultCompactWriter.writeArrayOfFloat64(fieldName, value);
        return this;
    }

    @Override
    @Nonnull
    public GenericRecordBuilder setArrayOfFloat32(@Nonnull String fieldName, @Nullable float[] value) {
        this.checkIfAlreadyWritten(fieldName);
        this.defaultCompactWriter.writeArrayOfFloat32(fieldName, value);
        return this;
    }

    @Override
    @Nonnull
    public GenericRecordBuilder setArrayOfInt16(@Nonnull String fieldName, @Nullable short[] value) {
        this.checkIfAlreadyWritten(fieldName);
        this.defaultCompactWriter.writeArrayOfInt16(fieldName, value);
        return this;
    }

    @Override
    @Nonnull
    public GenericRecordBuilder setArrayOfNullableBoolean(@Nonnull String fieldName, @Nullable Boolean[] value) {
        this.checkIfAlreadyWritten(fieldName);
        this.defaultCompactWriter.writeArrayOfNullableBoolean(fieldName, value);
        return this;
    }

    @Override
    @Nonnull
    public GenericRecordBuilder setArrayOfNullableInt8(@Nonnull String fieldName, @Nullable Byte[] value) {
        this.checkIfAlreadyWritten(fieldName);
        this.defaultCompactWriter.writeArrayOfNullableInt8(fieldName, value);
        return this;
    }

    @Override
    @Nonnull
    public GenericRecordBuilder setArrayOfNullableFloat32(@Nonnull String fieldName, @Nullable Float[] value) {
        this.checkIfAlreadyWritten(fieldName);
        this.defaultCompactWriter.writeArrayOfNullableFloat32(fieldName, value);
        return this;
    }

    @Override
    @Nonnull
    public GenericRecordBuilder setArrayOfNullableInt32(@Nonnull String fieldName, @Nullable Integer[] value) {
        this.checkIfAlreadyWritten(fieldName);
        this.defaultCompactWriter.writeArrayOfNullableInt32(fieldName, value);
        return this;
    }

    @Override
    @Nonnull
    public GenericRecordBuilder setArrayOfNullableFloat64(@Nonnull String fieldName, @Nullable Double[] value) {
        this.checkIfAlreadyWritten(fieldName);
        this.defaultCompactWriter.writeArrayOfNullableFloat64(fieldName, value);
        return this;
    }

    @Override
    @Nonnull
    public GenericRecordBuilder setArrayOfNullableInt64(@Nonnull String fieldName, @Nullable Long[] value) {
        this.checkIfAlreadyWritten(fieldName);
        this.defaultCompactWriter.writeArrayOfNullableInt64(fieldName, value);
        return this;
    }

    @Override
    @Nonnull
    public GenericRecordBuilder setArrayOfNullableInt16(@Nonnull String fieldName, @Nullable Short[] value) {
        this.checkIfAlreadyWritten(fieldName);
        this.defaultCompactWriter.writeArrayOfNullableInt16(fieldName, value);
        return this;
    }

    @Override
    @Nonnull
    public GenericRecordBuilder setArrayOfString(@Nonnull String fieldName, @Nullable String[] value) {
        this.checkIfAlreadyWritten(fieldName);
        this.defaultCompactWriter.writeArrayOfString(fieldName, value);
        return this;
    }

    @Override
    @Nonnull
    public GenericRecordBuilder setArrayOfDecimal(@Nonnull String fieldName, @Nullable BigDecimal[] value) {
        this.checkIfAlreadyWritten(fieldName);
        this.defaultCompactWriter.writeArrayOfDecimal(fieldName, value);
        return this;
    }

    @Override
    @Nonnull
    public GenericRecordBuilder setArrayOfTime(@Nonnull String fieldName, @Nullable LocalTime[] value) {
        this.checkIfAlreadyWritten(fieldName);
        this.defaultCompactWriter.writeArrayOfTime(fieldName, value);
        return this;
    }

    @Override
    @Nonnull
    public GenericRecordBuilder setArrayOfDate(@Nonnull String fieldName, @Nullable LocalDate[] value) {
        this.checkIfAlreadyWritten(fieldName);
        this.defaultCompactWriter.writeArrayOfDate(fieldName, value);
        return this;
    }

    @Override
    @Nonnull
    public GenericRecordBuilder setArrayOfTimestamp(@Nonnull String fieldName, @Nullable LocalDateTime[] value) {
        this.checkIfAlreadyWritten(fieldName);
        this.defaultCompactWriter.writeArrayOfTimestamp(fieldName, value);
        return this;
    }

    @Override
    @Nonnull
    public GenericRecordBuilder setArrayOfTimestampWithTimezone(@Nonnull String fieldName, @Nullable OffsetDateTime[] value) {
        this.checkIfAlreadyWritten(fieldName);
        this.defaultCompactWriter.writeArrayOfTimestampWithTimezone(fieldName, value);
        return this;
    }

    private void checkIfAlreadyWritten(@Nonnull String fieldName) {
        if (!this.writtenFields.add(fieldName)) {
            throw new HazelcastSerializationException("Field can only be written once");
        }
    }
}

