/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.util.phonehome;

import com.hazelcast.config.EvictionPolicy;
import com.hazelcast.config.HotRestartConfig;
import com.hazelcast.config.InMemoryFormat;
import com.hazelcast.config.MapConfig;
import com.hazelcast.config.MapStoreConfig;
import com.hazelcast.core.DistributedObject;
import com.hazelcast.instance.impl.Node;
import com.hazelcast.internal.util.phonehome.MetricsCollector;
import com.hazelcast.internal.util.phonehome.PhoneHomeMetrics;
import com.hazelcast.map.LocalMapStats;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import java.util.function.ToLongFunction;

class MapInfoCollector
implements MetricsCollector {
    private static final Predicate<MapConfig> IS_MAP_STORE_ENABLED = mapConfig -> mapConfig.getMapStoreConfig().isEnabled();
    private Map<String, MapConfig> mapConfigs;

    MapInfoCollector() {
    }

    @Override
    public void forEachMetric(Node node, BiConsumer<PhoneHomeMetrics, String> metricsConsumer2) {
        this.initMapConfigs(node);
        metricsConsumer2.accept(PhoneHomeMetrics.MAP_COUNT_WITH_READ_ENABLED, String.valueOf(this.countMapWithBackupReadEnabled()));
        metricsConsumer2.accept(PhoneHomeMetrics.MAP_COUNT_WITH_MAP_STORE_ENABLED, String.valueOf(this.countMapWithMapStoreEnabled()));
        metricsConsumer2.accept(PhoneHomeMetrics.MAP_COUNT_WITH_ATLEAST_ONE_QUERY_CACHE, String.valueOf(this.countMapWithAtleastOneQueryCache()));
        metricsConsumer2.accept(PhoneHomeMetrics.MAP_COUNT_WITH_ATLEAST_ONE_INDEX, String.valueOf(this.countMapWithAtleastOneIndex()));
        metricsConsumer2.accept(PhoneHomeMetrics.MAP_COUNT_WITH_HOT_RESTART_ENABLED, String.valueOf(this.countMapWithHotRestartEnabled()));
        metricsConsumer2.accept(PhoneHomeMetrics.MAP_COUNT_WITH_WAN_REPLICATION, String.valueOf(this.countMapWithWANReplication()));
        metricsConsumer2.accept(PhoneHomeMetrics.MAP_COUNT_WITH_ATLEAST_ONE_ATTRIBUTE, String.valueOf(this.countMapWithAtleastOneAttribute()));
        metricsConsumer2.accept(PhoneHomeMetrics.MAP_COUNT_USING_EVICTION, String.valueOf(this.countMapUsingEviction()));
        metricsConsumer2.accept(PhoneHomeMetrics.MAP_COUNT_USING_NATIVE_INMEMORY_FORMAT, String.valueOf(this.countMapWithNativeInMemoryFormat()));
        metricsConsumer2.accept(PhoneHomeMetrics.AVERAGE_PUT_LATENCY_OF_MAPS_USING_MAPSTORE, String.valueOf(this.mapOperationLatency(node, IS_MAP_STORE_ENABLED, LocalMapStats::getTotalPutLatency, LocalMapStats::getPutOperationCount)));
        metricsConsumer2.accept(PhoneHomeMetrics.AVERAGE_PUT_LATENCY_OF_MAPS_WITHOUT_MAPSTORE, String.valueOf(this.mapOperationLatency(node, IS_MAP_STORE_ENABLED.negate(), LocalMapStats::getTotalPutLatency, LocalMapStats::getPutOperationCount)));
        metricsConsumer2.accept(PhoneHomeMetrics.AVERAGE_GET_LATENCY_OF_MAPS_USING_MAPSTORE, String.valueOf(this.mapOperationLatency(node, IS_MAP_STORE_ENABLED, LocalMapStats::getTotalGetLatency, LocalMapStats::getGetOperationCount)));
        metricsConsumer2.accept(PhoneHomeMetrics.AVERAGE_GET_LATENCY_OF_MAPS_WITHOUT_MAPSTORE, String.valueOf(this.mapOperationLatency(node, IS_MAP_STORE_ENABLED.negate(), LocalMapStats::getTotalGetLatency, LocalMapStats::getGetOperationCount)));
    }

    private void initMapConfigs(Node node) {
        Collection<DistributedObject> objects = node.hazelcastInstance.getDistributedObjects();
        this.mapConfigs = new HashMap<String, MapConfig>();
        objects.stream().filter(obj -> obj.getServiceName().equals("hz:impl:mapService")).forEach(obj -> {
            MapConfig config = node.getConfig().findMapConfig(obj.getName());
            if (config != null) {
                this.mapConfigs.put(obj.getName(), config);
            }
        });
    }

    private long countMapWithBackupReadEnabled() {
        return this.mapConfigs.values().stream().filter(MapConfig::isReadBackupData).count();
    }

    private long countMapWithMapStoreEnabled() {
        return this.mapConfigs.values().stream().map(MapConfig::getMapStoreConfig).filter(MapStoreConfig::isEnabled).count();
    }

    private long countMapWithAtleastOneQueryCache() {
        return this.mapConfigs.values().stream().map(MapConfig::getQueryCacheConfigs).filter(queryCacheConfigs -> !queryCacheConfigs.isEmpty()).count();
    }

    private long countMapWithAtleastOneIndex() {
        return this.mapConfigs.values().stream().map(MapConfig::getIndexConfigs).filter(indexConfigs -> !indexConfigs.isEmpty()).count();
    }

    private long countMapWithHotRestartEnabled() {
        return this.mapConfigs.values().stream().map(MapConfig::getHotRestartConfig).filter(HotRestartConfig::isEnabled).count();
    }

    private long countMapWithWANReplication() {
        return this.mapConfigs.values().stream().map(MapConfig::getWanReplicationRef).filter(Objects::nonNull).count();
    }

    private long countMapWithAtleastOneAttribute() {
        return this.mapConfigs.values().stream().map(MapConfig::getAttributeConfigs).filter(attributeConfigs -> !attributeConfigs.isEmpty()).count();
    }

    private long countMapUsingEviction() {
        return this.mapConfigs.values().stream().map(MapConfig::getEvictionConfig).filter(evictionConfig -> evictionConfig.getEvictionPolicy() != EvictionPolicy.NONE).count();
    }

    private long countMapWithNativeInMemoryFormat() {
        return this.mapConfigs.values().stream().map(MapConfig::getInMemoryFormat).filter(inMemoryFormat -> inMemoryFormat == InMemoryFormat.NATIVE).count();
    }

    private long mapOperationLatency(Node node, Predicate<MapConfig> predicate, ToLongFunction<LocalMapStats> totalLatencyProvider, ToLongFunction<LocalMapStats> operationCountProvider) {
        LatencyInfo latencyInfo = new LatencyInfo(0L, 0L);
        this.mapConfigs.entrySet().stream().filter(entry -> predicate.test((MapConfig)entry.getValue())).map(entry -> node.hazelcastInstance.getMap((String)entry.getKey()).getLocalMapStats()).forEach(mapStats -> latencyInfo.add(totalLatencyProvider.applyAsLong((LocalMapStats)mapStats), operationCountProvider.applyAsLong((LocalMapStats)mapStats)));
        return latencyInfo.calculateAverage();
    }

    static class LatencyInfo {
        private long totalLatency;
        private long operationCount;

        LatencyInfo(long totalLatency, long operationCount) {
            this.totalLatency = totalLatency;
            this.operationCount = operationCount;
        }

        void add(long totalLatency, long operationCount) {
            this.totalLatency += totalLatency;
            this.operationCount += operationCount;
        }

        long calculateAverage() {
            return this.operationCount == 0L ? -1L : this.totalLatency / this.operationCount;
        }
    }
}

