/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl.connector;

import com.hazelcast.cluster.Address;
import com.hazelcast.function.FunctionEx;
import com.hazelcast.internal.iteration.IndexIterationPointer;
import com.hazelcast.internal.serialization.InternalSerializationService;
import com.hazelcast.internal.util.collection.PartitionIdSet;
import com.hazelcast.map.impl.operation.MapFetchIndexOperation;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import javax.annotation.Nonnull;

public abstract class AbstractIndexReader<B, R> {
    protected String objectName;
    protected InternalSerializationService serializationService;
    protected FunctionEx<B, List<R>> toRecordSetFn;

    public AbstractIndexReader(@Nonnull String objectName, @Nonnull FunctionEx<B, List<R>> toRecordSetFn) {
        this.objectName = objectName;
        this.toRecordSetFn = toRecordSetFn;
    }

    @Nonnull
    public abstract CompletableFuture<MapFetchIndexOperation.MapFetchIndexOperationResult> readBatch(Address var1, PartitionIdSet var2, IndexIterationPointer[] var3);

    @Nonnull
    public B toBatchResult(@Nonnull CompletableFuture<MapFetchIndexOperation.MapFetchIndexOperationResult> future) throws ExecutionException, InterruptedException {
        return (B)future.get();
    }

    @Nonnull
    public final List<R> toRecordSet(@Nonnull B result) {
        return this.toRecordSetFn.apply(result);
    }
}

