/*
 * Decompiled with CFR 0.152.
 */
package io.protostuff;

import io.protostuff.ByteString;
import io.protostuff.LinkBuffer;
import io.protostuff.Output;
import io.protostuff.ProtobufOutput;
import io.protostuff.Schema;
import io.protostuff.WireFormat;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;

public final class LowCopyProtobufOutput
implements Output {
    public LinkBuffer buffer;

    public LowCopyProtobufOutput() {
        this.buffer = new LinkBuffer();
    }

    public LowCopyProtobufOutput(LinkBuffer buffer) {
        this.buffer = buffer;
    }

    @Override
    public void writeInt32(int fieldNumber, int value, boolean repeated) throws IOException {
        if (value < 0) {
            this.buffer.writeVarInt32(WireFormat.makeTag(fieldNumber, 0));
            this.buffer.writeVarInt64(value);
        } else {
            this.buffer.writeVarInt32(WireFormat.makeTag(fieldNumber, 0));
            this.buffer.writeVarInt32(value);
        }
    }

    @Override
    public void writeUInt32(int fieldNumber, int value, boolean repeated) throws IOException {
        this.buffer.writeVarInt32(WireFormat.makeTag(fieldNumber, 0));
        this.buffer.writeVarInt32(value);
    }

    @Override
    public void writeSInt32(int fieldNumber, int value, boolean repeated) throws IOException {
        this.buffer.writeVarInt32(WireFormat.makeTag(fieldNumber, 0));
        this.buffer.writeVarInt32(ProtobufOutput.encodeZigZag32(value));
    }

    @Override
    public void writeFixed32(int fieldNumber, int value, boolean repeated) throws IOException {
        this.buffer.writeVarInt32(WireFormat.makeTag(fieldNumber, 5));
        this.buffer.writeInt32LE(value);
    }

    @Override
    public void writeSFixed32(int fieldNumber, int value, boolean repeated) throws IOException {
        this.buffer.writeVarInt32(WireFormat.makeTag(fieldNumber, 5));
        this.buffer.writeInt32LE(value);
    }

    @Override
    public void writeInt64(int fieldNumber, long value, boolean repeated) throws IOException {
        this.buffer.writeVarInt32(WireFormat.makeTag(fieldNumber, 0));
        this.buffer.writeVarInt64(value);
    }

    @Override
    public void writeUInt64(int fieldNumber, long value, boolean repeated) throws IOException {
        this.buffer.writeVarInt32(WireFormat.makeTag(fieldNumber, 0));
        this.buffer.writeVarInt64(value);
    }

    @Override
    public void writeSInt64(int fieldNumber, long value, boolean repeated) throws IOException {
        this.buffer.writeVarInt32(WireFormat.makeTag(fieldNumber, 0));
        this.buffer.writeVarInt64(ProtobufOutput.encodeZigZag64(value));
    }

    @Override
    public void writeFixed64(int fieldNumber, long value, boolean repeated) throws IOException {
        this.buffer.writeVarInt32(WireFormat.makeTag(fieldNumber, 1));
        this.buffer.writeInt64LE(value);
    }

    @Override
    public void writeSFixed64(int fieldNumber, long value, boolean repeated) throws IOException {
        this.buffer.writeVarInt32(WireFormat.makeTag(fieldNumber, 1));
        this.buffer.writeInt64LE(value);
    }

    @Override
    public void writeFloat(int fieldNumber, float value, boolean repeated) throws IOException {
        this.buffer.writeVarInt32(WireFormat.makeTag(fieldNumber, 5));
        this.buffer.writeInt32LE(Float.floatToRawIntBits(value));
    }

    @Override
    public void writeDouble(int fieldNumber, double value, boolean repeated) throws IOException {
        this.buffer.writeVarInt32(WireFormat.makeTag(fieldNumber, 1));
        this.buffer.writeInt64LE(Double.doubleToRawLongBits(value));
    }

    @Override
    public void writeBool(int fieldNumber, boolean value, boolean repeated) throws IOException {
        this.buffer.writeVarInt32(WireFormat.makeTag(fieldNumber, 0));
        this.buffer.writeByte(value ? (byte)1 : 0);
    }

    @Override
    public void writeEnum(int fieldNumber, int number, boolean repeated) throws IOException {
        this.writeInt32(fieldNumber, number, repeated);
    }

    @Override
    public void writeString(int fieldNumber, CharSequence value, boolean repeated) throws IOException {
        byte[] strbytes = value.toString().getBytes("UTF-8");
        this.writeByteArray(fieldNumber, strbytes, repeated);
    }

    @Override
    public void writeBytes(int fieldNumber, ByteString value, boolean repeated) throws IOException {
        this.writeByteArray(fieldNumber, value.getBytes(), repeated);
    }

    @Override
    public void writeByteArray(int fieldNumber, byte[] bytes, boolean repeated) throws IOException {
        this.writeByteRange(false, fieldNumber, bytes, 0, bytes.length, repeated);
    }

    @Override
    public void writeByteRange(boolean utf8String, int fieldNumber, byte[] value, int offset, int length, boolean repeated) throws IOException {
        this.buffer.writeVarInt32(WireFormat.makeTag(fieldNumber, 2));
        this.buffer.writeVarInt32(length);
        this.buffer.writeByteArray(value, offset, length);
    }

    @Override
    public <T> void writeObject(int fieldNumber, T value, Schema<T> schema, boolean repeated) throws IOException {
        LinkBuffer subBuf = new LinkBuffer(this.buffer.allocSize);
        LowCopyProtobufOutput subOutput = new LowCopyProtobufOutput(subBuf);
        schema.writeTo(subOutput, value);
        List<ByteBuffer> subBuffers = subBuf.finish();
        long subSize = subBuf.size();
        this.buffer.writeVarInt32(WireFormat.makeTag(fieldNumber, 2));
        this.buffer.writeVarInt64(subSize);
        for (ByteBuffer b : subBuffers) {
            this.buffer.writeByteBuffer(b);
        }
    }

    @Override
    public void writeBytes(int fieldNumber, ByteBuffer value, boolean repeated) throws IOException {
        this.writeByteRange(false, fieldNumber, value.array(), value.arrayOffset() + value.position(), value.remaining(), repeated);
    }
}

