/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.api.table.event;

import org.apache.seatunnel.api.event.EventType;
import org.apache.seatunnel.api.table.catalog.Column;
import org.apache.seatunnel.api.table.catalog.TableIdentifier;
import org.apache.seatunnel.api.table.event.AlterTableColumnEvent;

public class AlterTableAddColumnEvent
extends AlterTableColumnEvent {
    private final Column column;
    private final boolean first;
    private final String afterColumn;

    public AlterTableAddColumnEvent(TableIdentifier tableIdentifier, Column column, boolean first, String afterColumn) {
        super(tableIdentifier);
        this.column = column;
        this.first = first;
        this.afterColumn = afterColumn;
    }

    public static AlterTableAddColumnEvent addFirst(TableIdentifier tableIdentifier, Column column) {
        return new AlterTableAddColumnEvent(tableIdentifier, column, true, null);
    }

    public static AlterTableAddColumnEvent add(TableIdentifier tableIdentifier, Column column) {
        return new AlterTableAddColumnEvent(tableIdentifier, column, false, null);
    }

    public static AlterTableAddColumnEvent addAfter(TableIdentifier tableIdentifier, Column column, String afterColumn) {
        return new AlterTableAddColumnEvent(tableIdentifier, column, false, afterColumn);
    }

    @Override
    public EventType getEventType() {
        return EventType.SCHEMA_CHANGE_ADD_COLUMN;
    }

    public Column getColumn() {
        return this.column;
    }

    public boolean isFirst() {
        return this.first;
    }

    public String getAfterColumn() {
        return this.afterColumn;
    }

    @Override
    public String toString() {
        return "AlterTableAddColumnEvent(super=" + super.toString() + ", column=" + this.getColumn() + ", first=" + this.isFirst() + ", afterColumn=" + this.getAfterColumn() + ")";
    }
}

