/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.common.exception;

import java.util.HashMap;
import java.util.Map;
import org.apache.seatunnel.common.exception.ExceptionParamsUtil;
import org.apache.seatunnel.common.exception.SeaTunnelErrorCode;
import org.apache.seatunnel.shade.com.fasterxml.jackson.core.JsonProcessingException;
import org.apache.seatunnel.shade.com.fasterxml.jackson.core.type.TypeReference;
import org.apache.seatunnel.shade.com.fasterxml.jackson.databind.ObjectMapper;

public class SeaTunnelRuntimeException
extends RuntimeException {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private final SeaTunnelErrorCode seaTunnelErrorCode;
    private final Map<String, String> params;

    public SeaTunnelRuntimeException(SeaTunnelErrorCode seaTunnelErrorCode, String errorMessage) {
        super(seaTunnelErrorCode.getErrorMessage() + " - " + errorMessage);
        this.seaTunnelErrorCode = seaTunnelErrorCode;
        this.params = new HashMap<String, String>();
        ExceptionParamsUtil.assertParamsMatchWithDescription(seaTunnelErrorCode.getDescription(), this.params);
    }

    public SeaTunnelRuntimeException(SeaTunnelErrorCode seaTunnelErrorCode, String errorMessage, Throwable cause) {
        super(seaTunnelErrorCode.getErrorMessage() + " - " + errorMessage, cause);
        this.seaTunnelErrorCode = seaTunnelErrorCode;
        this.params = new HashMap<String, String>();
        ExceptionParamsUtil.assertParamsMatchWithDescription(seaTunnelErrorCode.getDescription(), this.params);
    }

    public SeaTunnelRuntimeException(SeaTunnelErrorCode seaTunnelErrorCode, Throwable cause) {
        super(seaTunnelErrorCode.getErrorMessage(), cause);
        this.seaTunnelErrorCode = seaTunnelErrorCode;
        this.params = new HashMap<String, String>();
        ExceptionParamsUtil.assertParamsMatchWithDescription(seaTunnelErrorCode.getDescription(), this.params);
    }

    public SeaTunnelRuntimeException(SeaTunnelErrorCode seaTunnelErrorCode, Map<String, String> params) {
        super(ExceptionParamsUtil.getDescription(seaTunnelErrorCode.getErrorMessage(), params));
        this.seaTunnelErrorCode = seaTunnelErrorCode;
        this.params = params;
    }

    public SeaTunnelRuntimeException(SeaTunnelErrorCode seaTunnelErrorCode, Map<String, String> params, Throwable cause) {
        super(ExceptionParamsUtil.getDescription(seaTunnelErrorCode.getErrorMessage(), params), cause);
        this.seaTunnelErrorCode = seaTunnelErrorCode;
        this.params = params;
    }

    public SeaTunnelErrorCode getSeaTunnelErrorCode() {
        return this.seaTunnelErrorCode;
    }

    public Map<String, String> getParams() {
        return this.params;
    }

    public Map<String, String> getParamsValueAsMap(String key) {
        try {
            return OBJECT_MAPPER.readValue(this.params.get(key), new TypeReference<Map<String, String>>(){});
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public <T> T getParamsValueAs(String key) {
        try {
            return OBJECT_MAPPER.readValue(this.params.get(key), new TypeReference<T>(){});
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }
}

