/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.common.utils;

import java.io.Serializable;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public final class JdbcUrlUtil {
    private static final Pattern URL_PATTERN = Pattern.compile("^(?<url>jdbc:.+?//(?<host>.+?):(?<port>\\d+?))(/(?<database>.*?))*(?<suffix>\\?.*)*$");

    private JdbcUrlUtil() {
    }

    public static UrlInfo getUrlInfo(String url) {
        Matcher matcher = URL_PATTERN.matcher(url);
        if (matcher.find()) {
            String urlWithoutDatabase = matcher.group("url");
            String database = matcher.group("database");
            return new UrlInfo(url, urlWithoutDatabase, matcher.group("host"), Integer.valueOf(matcher.group("port")), database, matcher.group("suffix"));
        }
        throw new IllegalArgumentException("The jdbc url format is incorrect: " + url);
    }

    public static class UrlInfo
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final String origin;
        private final String urlWithoutDatabase;
        private final String host;
        private final Integer port;
        private final String suffix;
        private final String defaultDatabase;

        public UrlInfo(String origin, String urlWithoutDatabase, String host, Integer port, String defaultDatabase, String suffix) {
            this.origin = origin;
            this.urlWithoutDatabase = urlWithoutDatabase;
            this.host = host;
            this.port = port;
            this.defaultDatabase = defaultDatabase;
            this.suffix = suffix == null ? "" : suffix;
        }

        public Optional<String> getUrlWithDatabase() {
            return StringUtils.isBlank(this.defaultDatabase) ? Optional.empty() : Optional.of(this.urlWithoutDatabase + "/" + this.defaultDatabase + this.suffix);
        }

        public Optional<String> getDefaultDatabase() {
            return StringUtils.isBlank(this.defaultDatabase) ? Optional.empty() : Optional.of(this.defaultDatabase);
        }

        public String getUrlWithDatabase(String database) {
            return this.urlWithoutDatabase + "/" + database + this.suffix;
        }

        public String getOrigin() {
            return this.origin;
        }

        public String getUrlWithoutDatabase() {
            return this.urlWithoutDatabase;
        }

        public String getHost() {
            return this.host;
        }

        public Integer getPort() {
            return this.port;
        }

        public String getSuffix() {
            return this.suffix;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof UrlInfo)) {
                return false;
            }
            UrlInfo other = (UrlInfo)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Integer this$port = this.getPort();
            Integer other$port = other.getPort();
            if (this$port == null ? other$port != null : !((Object)this$port).equals(other$port)) {
                return false;
            }
            String this$origin = this.getOrigin();
            String other$origin = other.getOrigin();
            if (this$origin == null ? other$origin != null : !this$origin.equals(other$origin)) {
                return false;
            }
            String this$urlWithoutDatabase = this.getUrlWithoutDatabase();
            String other$urlWithoutDatabase = other.getUrlWithoutDatabase();
            if (this$urlWithoutDatabase == null ? other$urlWithoutDatabase != null : !this$urlWithoutDatabase.equals(other$urlWithoutDatabase)) {
                return false;
            }
            String this$host = this.getHost();
            String other$host = other.getHost();
            if (this$host == null ? other$host != null : !this$host.equals(other$host)) {
                return false;
            }
            String this$suffix = this.getSuffix();
            String other$suffix = other.getSuffix();
            if (this$suffix == null ? other$suffix != null : !this$suffix.equals(other$suffix)) {
                return false;
            }
            Optional<String> this$defaultDatabase = this.getDefaultDatabase();
            Optional<String> other$defaultDatabase = other.getDefaultDatabase();
            return !(this$defaultDatabase == null ? other$defaultDatabase != null : !((Object)this$defaultDatabase).equals(other$defaultDatabase));
        }

        protected boolean canEqual(Object other) {
            return other instanceof UrlInfo;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Integer $port = this.getPort();
            result = result * 59 + ($port == null ? 43 : ((Object)$port).hashCode());
            String $origin = this.getOrigin();
            result = result * 59 + ($origin == null ? 43 : $origin.hashCode());
            String $urlWithoutDatabase = this.getUrlWithoutDatabase();
            result = result * 59 + ($urlWithoutDatabase == null ? 43 : $urlWithoutDatabase.hashCode());
            String $host = this.getHost();
            result = result * 59 + ($host == null ? 43 : $host.hashCode());
            String $suffix = this.getSuffix();
            result = result * 59 + ($suffix == null ? 43 : $suffix.hashCode());
            Optional<String> $defaultDatabase = this.getDefaultDatabase();
            result = result * 59 + ($defaultDatabase == null ? 43 : ((Object)$defaultDatabase).hashCode());
            return result;
        }

        public String toString() {
            return "JdbcUrlUtil.UrlInfo(origin=" + this.getOrigin() + ", urlWithoutDatabase=" + this.getUrlWithoutDatabase() + ", host=" + this.getHost() + ", port=" + this.getPort() + ", suffix=" + this.getSuffix() + ", defaultDatabase=" + this.getDefaultDatabase() + ")";
        }
    }
}

