/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.core.starter.utils;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import lombok.NonNull;
import org.apache.seatunnel.api.configuration.ConfigAdapter;
import org.apache.seatunnel.common.utils.ParserException;
import org.apache.seatunnel.core.starter.utils.ConfigAdapterUtils;
import org.apache.seatunnel.core.starter.utils.ConfigShadeUtils;
import org.apache.seatunnel.shade.com.typesafe.config.Config;
import org.apache.seatunnel.shade.com.typesafe.config.ConfigFactory;
import org.apache.seatunnel.shade.com.typesafe.config.ConfigParseOptions;
import org.apache.seatunnel.shade.com.typesafe.config.ConfigRenderOptions;
import org.apache.seatunnel.shade.com.typesafe.config.ConfigResolveOptions;
import org.apache.seatunnel.shade.com.typesafe.config.impl.Parseable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigBuilder {
    private static final Logger log = LoggerFactory.getLogger(ConfigBuilder.class);
    public static final ConfigRenderOptions CONFIG_RENDER_OPTIONS = ConfigRenderOptions.concise().setFormatted(true);

    private ConfigBuilder() {
    }

    private static Config ofInner(@NonNull Path filePath, List<String> variables) {
        if (filePath == null) {
            throw new NullPointerException("filePath is marked non-null but is null");
        }
        Config config = ConfigFactory.parseFile(filePath.toFile()).resolve(ConfigResolveOptions.defaults().setAllowUnresolved(true));
        return ConfigShadeUtils.decryptConfig(ConfigBuilder.backfillUserVariables(config, variables));
    }

    public static Config of(@NonNull String filePath) {
        if (filePath == null) {
            throw new NullPointerException("filePath is marked non-null but is null");
        }
        Path path = Paths.get(filePath, new String[0]);
        return ConfigBuilder.of(path);
    }

    public static Config of(@NonNull String filePath, List<String> variables) {
        if (filePath == null) {
            throw new NullPointerException("filePath is marked non-null but is null");
        }
        Path path = Paths.get(filePath, new String[0]);
        return ConfigBuilder.of(path, variables);
    }

    public static Config of(@NonNull Path filePath) {
        if (filePath == null) {
            throw new NullPointerException("filePath is marked non-null but is null");
        }
        return ConfigBuilder.of(filePath, null);
    }

    public static Config of(@NonNull Path filePath, List<String> variables) {
        if (filePath == null) {
            throw new NullPointerException("filePath is marked non-null but is null");
        }
        log.info("Loading config file from path: {}", (Object)filePath);
        Optional<ConfigAdapter> adapterSupplier = ConfigAdapterUtils.selectAdapter(filePath);
        Config config = adapterSupplier.map(adapter -> ConfigBuilder.of(adapter, filePath, variables)).orElseGet(() -> ConfigBuilder.ofInner(filePath, variables));
        return config;
    }

    public static Config of(@NonNull Map<String, Object> objectMap) {
        if (objectMap == null) {
            throw new NullPointerException("objectMap is marked non-null but is null");
        }
        return ConfigBuilder.of(objectMap, false);
    }

    public static Config of(@NonNull Map<String, Object> objectMap, boolean isEncrypt) {
        if (objectMap == null) {
            throw new NullPointerException("objectMap is marked non-null but is null");
        }
        log.info("Loading config file from objectMap");
        Config config = ConfigFactory.parseMap(objectMap).resolve(ConfigResolveOptions.defaults().setAllowUnresolved(true)).resolveWith(ConfigFactory.systemProperties(), ConfigResolveOptions.defaults().setAllowUnresolved(true));
        if (!isEncrypt) {
            config = ConfigShadeUtils.decryptConfig(config);
        }
        return config;
    }

    public static Config of(@NonNull ConfigAdapter configAdapter, @NonNull Path filePath, List<String> variables) {
        if (configAdapter == null) {
            throw new NullPointerException("configAdapter is marked non-null but is null");
        }
        if (filePath == null) {
            throw new NullPointerException("filePath is marked non-null but is null");
        }
        log.info("With config adapter spi {}", (Object)configAdapter.getClass().getName());
        try {
            Map<String, Object> flattenedMap = configAdapter.loadConfig(filePath);
            Config config = ConfigFactory.parseMap(flattenedMap);
            return ConfigShadeUtils.decryptConfig(ConfigBuilder.backfillUserVariables(config, variables));
        }
        catch (IllegalArgumentException | ParserException e) {
            throw e;
        }
        catch (Exception warn) {
            log.warn("Loading config failed with spi {}, fallback to HOCON loader.", (Object)configAdapter.getClass().getName());
            return ConfigBuilder.ofInner(filePath, variables);
        }
    }

    private static Config backfillUserVariables(Config config, List<String> variables) {
        if (variables != null) {
            variables.stream().filter(Objects::nonNull).map(variable -> variable.split("=", 2)).filter(pair -> ((String[])pair).length == 2).forEach(pair -> System.setProperty(pair[0], pair[1]));
            Config systemConfig = Parseable.newProperties(System.getProperties(), ConfigParseOptions.defaults().setOriginDescription("system properties")).parse().toConfig();
            return config.resolveWith(systemConfig, ConfigResolveOptions.defaults().setAllowUnresolved(true));
        }
        return config;
    }
}

