/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.engine.server.checkpoint;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.seatunnel.engine.core.checkpoint.CheckpointType;
import org.apache.seatunnel.engine.server.execution.TaskLocation;
import org.apache.seatunnel.engine.server.task.record.Barrier;

public class CheckpointBarrier
implements Barrier,
Serializable {
    private final long id;
    private final long timestamp;
    private final CheckpointType checkpointType;
    private final Set<TaskLocation> prepareCloseTasks;
    private final Set<TaskLocation> closedTasks;

    public CheckpointBarrier(long id, long timestamp, CheckpointType checkpointType) {
        this(id, timestamp, checkpointType, Collections.emptySet(), Collections.emptySet());
    }

    public CheckpointBarrier(long id, long timestamp, CheckpointType checkpointType, Set<TaskLocation> prepareCloseTasks, Set<TaskLocation> closedTasks) {
        this.id = id;
        this.timestamp = timestamp;
        this.checkpointType = Preconditions.checkNotNull(checkpointType);
        this.prepareCloseTasks = prepareCloseTasks;
        this.closedTasks = closedTasks;
        if (new HashSet<TaskLocation>(prepareCloseTasks).removeAll(closedTasks)) {
            throw new IllegalArgumentException("The prepareCloseTasks collection should not contain elements of the closedTasks collection");
        }
    }

    @Override
    public boolean snapshot() {
        return true;
    }

    @Override
    public boolean prepareClose() {
        return this.checkpointType.isFinalCheckpoint();
    }

    @Override
    public boolean prepareClose(TaskLocation task) {
        if (this.prepareClose()) {
            return true;
        }
        return this.prepareCloseTasks.contains(task);
    }

    @Override
    public Set<TaskLocation> closedTasks() {
        return Collections.unmodifiableSet(this.closedTasks);
    }

    public int hashCode() {
        return Objects.hashCode(new Object[]{this.id, this.timestamp, this.checkpointType});
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other == null || other.getClass() != CheckpointBarrier.class) {
            return false;
        }
        CheckpointBarrier that = (CheckpointBarrier)other;
        return that.id == this.id && that.timestamp == this.timestamp && this.checkpointType.equals((Object)that.checkpointType);
    }

    public String toString() {
        return String.format("CheckpointBarrier %d @ %d type: %s, prepareClose: %s, closed: %s", new Object[]{this.id, this.timestamp, this.checkpointType, this.prepareCloseTasks, this.closedTasks});
    }

    public boolean isAuto() {
        return this.checkpointType.isAuto();
    }

    @Override
    public long getId() {
        return this.id;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public CheckpointType getCheckpointType() {
        return this.checkpointType;
    }

    public Set<TaskLocation> getPrepareCloseTasks() {
        return this.prepareCloseTasks;
    }

    public Set<TaskLocation> getClosedTasks() {
        return this.closedTasks;
    }
}

