/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.engine.server.checkpoint;

import com.hazelcast.jet.datamodel.Tuple2;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import org.apache.seatunnel.engine.server.checkpoint.ActionStateKey;
import org.apache.seatunnel.engine.server.execution.TaskLocation;

public class CheckpointPlan {
    public static final Integer COORDINATOR_INDEX = -1;
    private final int pipelineId;
    private final Set<TaskLocation> pipelineSubtasks;
    private final Set<TaskLocation> startingSubtasks;
    private final Map<ActionStateKey, Integer> pipelineActions;
    private final Map<TaskLocation, Set<Tuple2<ActionStateKey, Integer>>> subtaskActions;

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        return "CheckpointPlan(pipelineId=" + this.getPipelineId() + ", pipelineSubtasks=" + this.getPipelineSubtasks() + ", startingSubtasks=" + this.getStartingSubtasks() + ", pipelineActions=" + this.getPipelineActions() + ", subtaskActions=" + this.getSubtaskActions() + ")";
    }

    public int getPipelineId() {
        return this.pipelineId;
    }

    public Set<TaskLocation> getPipelineSubtasks() {
        return this.pipelineSubtasks;
    }

    public Set<TaskLocation> getStartingSubtasks() {
        return this.startingSubtasks;
    }

    public Map<ActionStateKey, Integer> getPipelineActions() {
        return this.pipelineActions;
    }

    public Map<TaskLocation, Set<Tuple2<ActionStateKey, Integer>>> getSubtaskActions() {
        return this.subtaskActions;
    }

    private CheckpointPlan(int pipelineId, Set<TaskLocation> pipelineSubtasks, Set<TaskLocation> startingSubtasks, Map<ActionStateKey, Integer> pipelineActions, Map<TaskLocation, Set<Tuple2<ActionStateKey, Integer>>> subtaskActions) {
        this.pipelineId = pipelineId;
        this.pipelineSubtasks = pipelineSubtasks;
        this.startingSubtasks = startingSubtasks;
        this.pipelineActions = pipelineActions;
        this.subtaskActions = subtaskActions;
    }

    public static final class Builder {
        private int pipelineId;
        private final Set<TaskLocation> pipelineSubtasks = new CopyOnWriteArraySet<TaskLocation>();
        private final Set<TaskLocation> startingSubtasks = new CopyOnWriteArraySet<TaskLocation>();
        private final Map<ActionStateKey, Integer> pipelineActions = new ConcurrentHashMap<ActionStateKey, Integer>();
        private final Map<TaskLocation, Set<Tuple2<ActionStateKey, Integer>>> subtaskActions = new ConcurrentHashMap<TaskLocation, Set<Tuple2<ActionStateKey, Integer>>>();

        private Builder() {
        }

        public Builder pipelineSubtasks(Set<TaskLocation> pipelineTaskIds) {
            this.pipelineSubtasks.addAll(pipelineTaskIds);
            return this;
        }

        public Builder startingSubtasks(Set<TaskLocation> startingVertices) {
            this.startingSubtasks.addAll(startingVertices);
            return this;
        }

        public Builder pipelineActions(Map<ActionStateKey, Integer> pipelineActions) {
            this.pipelineActions.putAll(pipelineActions);
            return this;
        }

        public Builder subtaskActions(Map<TaskLocation, Set<Tuple2<ActionStateKey, Integer>>> subtaskActions) {
            this.subtaskActions.putAll(subtaskActions);
            return this;
        }

        public Builder pipelineId(int pipelineId) {
            this.pipelineId = pipelineId;
            return this;
        }

        public CheckpointPlan build() {
            return new CheckpointPlan(this.pipelineId, this.pipelineSubtasks, this.startingSubtasks, this.pipelineActions, this.subtaskActions);
        }

        public String toString() {
            return "CheckpointPlan.Builder(pipelineId=" + this.pipelineId + ", pipelineSubtasks=" + this.pipelineSubtasks + ", startingSubtasks=" + this.startingSubtasks + ", pipelineActions=" + this.pipelineActions + ", subtaskActions=" + this.subtaskActions + ")";
        }
    }
}

