/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.plugin.discovery;

import org.apache.commons.lang3.StringUtils;

public class PluginIdentifier {
    private final String engineType;
    private final String pluginType;
    private final String pluginName;

    private PluginIdentifier(String engineType, String pluginType, String pluginName) {
        this.engineType = engineType;
        this.pluginType = pluginType;
        this.pluginName = pluginName;
    }

    public static PluginIdentifier of(String engineType, String pluginType, String pluginName) {
        return new PluginIdentifier(engineType, pluginType, pluginName);
    }

    public String getEngineType() {
        return this.engineType;
    }

    public String getPluginType() {
        return this.pluginType;
    }

    public String getPluginName() {
        return this.pluginName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PluginIdentifier that = (PluginIdentifier)o;
        if (!StringUtils.equalsIgnoreCase(this.engineType, that.engineType)) {
            return false;
        }
        if (!StringUtils.equalsIgnoreCase(this.pluginType, that.pluginType)) {
            return false;
        }
        return StringUtils.equalsIgnoreCase(this.pluginName, that.pluginName);
    }

    public int hashCode() {
        int result = this.engineType != null ? this.engineType.toLowerCase().hashCode() : 0;
        result = 31 * result + (this.pluginType != null ? this.pluginType.toLowerCase().hashCode() : 0);
        result = 31 * result + (this.pluginName != null ? this.pluginName.toLowerCase().hashCode() : 0);
        return result;
    }

    public String toString() {
        return "PluginIdentifier{engineType='" + this.engineType + '\'' + ", pluginType='" + this.pluginType + '\'' + ", pluginName='" + this.pluginName + '\'' + '}';
    }
}

