/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.transform.sql.zeta;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import net.sf.jsqlparser.expression.BinaryExpression;
import net.sf.jsqlparser.expression.CaseExpression;
import net.sf.jsqlparser.expression.CastExpression;
import net.sf.jsqlparser.expression.DoubleValue;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.ExtractExpression;
import net.sf.jsqlparser.expression.Function;
import net.sf.jsqlparser.expression.LongValue;
import net.sf.jsqlparser.expression.NullValue;
import net.sf.jsqlparser.expression.Parenthesis;
import net.sf.jsqlparser.expression.SignedExpression;
import net.sf.jsqlparser.expression.StringValue;
import net.sf.jsqlparser.expression.TimeKeyExpression;
import net.sf.jsqlparser.expression.WhenClause;
import net.sf.jsqlparser.expression.operators.arithmetic.Concat;
import net.sf.jsqlparser.expression.operators.conditional.AndExpression;
import net.sf.jsqlparser.expression.operators.conditional.OrExpression;
import net.sf.jsqlparser.expression.operators.relational.ComparisonOperator;
import net.sf.jsqlparser.expression.operators.relational.ExpressionList;
import net.sf.jsqlparser.expression.operators.relational.InExpression;
import net.sf.jsqlparser.expression.operators.relational.IsNullExpression;
import net.sf.jsqlparser.expression.operators.relational.LikeExpression;
import net.sf.jsqlparser.expression.operators.relational.NotEqualsTo;
import net.sf.jsqlparser.schema.Column;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.seatunnel.api.table.type.BasicType;
import org.apache.seatunnel.api.table.type.DecimalType;
import org.apache.seatunnel.api.table.type.LocalTimeType;
import org.apache.seatunnel.api.table.type.MapType;
import org.apache.seatunnel.api.table.type.SeaTunnelDataType;
import org.apache.seatunnel.api.table.type.SeaTunnelRowType;
import org.apache.seatunnel.api.table.type.SqlType;
import org.apache.seatunnel.common.exception.CommonErrorCodeDeprecated;
import org.apache.seatunnel.common.exception.SeaTunnelErrorCode;
import org.apache.seatunnel.transform.exception.TransformException;
import org.apache.seatunnel.transform.sql.zeta.ZetaUDF;

public class ZetaSQLType {
    public static final String DECIMAL = "DECIMAL";
    public static final String VARCHAR = "VARCHAR";
    public static final String STRING = "STRING";
    public static final String INT = "INT";
    public static final String INTEGER = "INTEGER";
    public static final String BIGINT = "BIGINT";
    public static final String LONG = "LONG";
    public static final String BYTE = "BYTE";
    public static final String DOUBLE = "DOUBLE";
    public static final String FLOAT = "FLOAT";
    public static final String TIMESTAMP = "TIMESTAMP";
    public static final String DATETIME = "DATETIME";
    public static final String DATE = "DATE";
    public static final String TIME = "TIME";
    private final SeaTunnelRowType inputRowType;
    private final List<ZetaUDF> udfList;

    public ZetaSQLType(SeaTunnelRowType inputRowType, List<ZetaUDF> udfList) {
        this.inputRowType = inputRowType;
        this.udfList = udfList;
    }

    public SeaTunnelDataType<?> getExpressionType(Expression expression) {
        if (expression instanceof NullValue) {
            return BasicType.VOID_TYPE;
        }
        if (expression instanceof SignedExpression) {
            return this.getExpressionType(((SignedExpression)expression).getExpression());
        }
        if (expression instanceof DoubleValue) {
            return BasicType.DOUBLE_TYPE;
        }
        if (expression instanceof LongValue) {
            long longVal = ((LongValue)expression).getValue();
            if (longVal <= Integer.MAX_VALUE && longVal >= Integer.MIN_VALUE) {
                return BasicType.INT_TYPE;
            }
            return BasicType.LONG_TYPE;
        }
        if (expression instanceof StringValue) {
            return BasicType.STRING_TYPE;
        }
        if (expression instanceof Column) {
            Column columnExp = (Column)expression;
            String columnName = columnExp.getColumnName();
            int index = this.inputRowType.indexOf(columnName, false);
            if (index != -1) {
                return this.inputRowType.getFieldType(index);
            }
            String fullyQualifiedName = columnExp.getFullyQualifiedName();
            String[] columnNames = fullyQualifiedName.split("\\.");
            int deep = columnNames.length;
            SeaTunnelRowType parRowType = this.inputRowType;
            SeaTunnelDataType filedTypeRes = null;
            for (int i = 0; i < deep; ++i) {
                int idx = parRowType.indexOf(columnNames[i], false);
                if (idx == -1) {
                    throw new IllegalArgumentException(String.format("can't find field [%s]", fullyQualifiedName));
                }
                filedTypeRes = parRowType.getFieldType(idx);
                if (filedTypeRes instanceof SeaTunnelRowType) {
                    parRowType = (SeaTunnelRowType)filedTypeRes;
                    continue;
                }
                if (!(filedTypeRes instanceof MapType)) continue;
                if (i != deep - 2) {
                    throw new IllegalArgumentException("For now, we only support map struct is the latest struct in inner query function! Please modify your query!");
                }
                return ((MapType)filedTypeRes).getValueType();
            }
            return filedTypeRes;
        }
        if (expression instanceof Function) {
            return this.getFunctionType((Function)expression);
        }
        if (expression instanceof TimeKeyExpression) {
            return this.getTimeKeyExprType((TimeKeyExpression)expression);
        }
        if (expression instanceof ExtractExpression) {
            return BasicType.INT_TYPE;
        }
        if (expression instanceof Parenthesis) {
            Parenthesis parenthesis = (Parenthesis)expression;
            return this.getExpressionType(parenthesis.getExpression());
        }
        if (expression instanceof Concat) {
            return BasicType.STRING_TYPE;
        }
        if (expression instanceof CaseExpression) {
            return this.getCaseType((CaseExpression)expression);
        }
        if (expression instanceof ComparisonOperator || expression instanceof IsNullExpression || expression instanceof InExpression || expression instanceof LikeExpression || expression instanceof AndExpression || expression instanceof OrExpression || expression instanceof NotEqualsTo) {
            return BasicType.BOOLEAN_TYPE;
        }
        if (expression instanceof CastExpression) {
            return this.getCastType((CastExpression)expression);
        }
        if (expression instanceof BinaryExpression) {
            BinaryExpression binaryExpression = (BinaryExpression)expression;
            SeaTunnelDataType<?> leftType = this.getExpressionType(binaryExpression.getLeftExpression());
            SeaTunnelDataType<?> rightType = this.getExpressionType(binaryExpression.getRightExpression());
            if (!(leftType.getSqlType() != SqlType.TINYINT && leftType.getSqlType() != SqlType.SMALLINT && leftType.getSqlType() != SqlType.INT || rightType.getSqlType() != SqlType.TINYINT && rightType.getSqlType() != SqlType.SMALLINT && rightType.getSqlType() != SqlType.INT)) {
                return BasicType.INT_TYPE;
            }
            if ((leftType.getSqlType() == SqlType.TINYINT || leftType.getSqlType() == SqlType.SMALLINT || leftType.getSqlType() == SqlType.INT || leftType.getSqlType() == SqlType.BIGINT) && rightType.getSqlType() == SqlType.BIGINT) {
                return BasicType.LONG_TYPE;
            }
            if ((rightType.getSqlType() == SqlType.TINYINT || rightType.getSqlType() == SqlType.SMALLINT || rightType.getSqlType() == SqlType.INT || rightType.getSqlType() == SqlType.BIGINT) && leftType.getSqlType() == SqlType.BIGINT) {
                return BasicType.LONG_TYPE;
            }
            if (leftType.getSqlType() == SqlType.DECIMAL || rightType.getSqlType() == SqlType.DECIMAL) {
                DecimalType decimalType;
                int precision = 0;
                int scale = 0;
                if (leftType.getSqlType() == SqlType.DECIMAL) {
                    decimalType = (DecimalType)leftType;
                    precision = decimalType.getPrecision();
                    scale = decimalType.getScale();
                }
                if (rightType.getSqlType() == SqlType.DECIMAL) {
                    decimalType = (DecimalType)rightType;
                    precision = Math.max(decimalType.getPrecision(), precision);
                    scale = Math.max(decimalType.getScale(), scale);
                }
                return new DecimalType(precision, scale);
            }
            if (leftType.getSqlType() == SqlType.FLOAT || leftType.getSqlType() == SqlType.DOUBLE || rightType.getSqlType() == SqlType.FLOAT || rightType.getSqlType() == SqlType.DOUBLE) {
                return BasicType.DOUBLE_TYPE;
            }
        }
        throw new TransformException((SeaTunnelErrorCode)CommonErrorCodeDeprecated.UNSUPPORTED_OPERATION, String.format("Unsupported SQL Expression: %s ", expression.toString()));
    }

    public boolean isNumberType(SqlType type) {
        return type.compareTo((Enum)SqlType.TINYINT) >= 0 && type.compareTo((Enum)SqlType.DECIMAL) <= 0;
    }

    public SeaTunnelDataType<?> getMaxType(SeaTunnelDataType<?> leftType, SeaTunnelDataType<?> rightType) {
        boolean isAllNumber;
        if (leftType == null || BasicType.VOID_TYPE.equals(leftType)) {
            return rightType;
        }
        if (rightType == null || BasicType.VOID_TYPE.equals(rightType)) {
            return leftType;
        }
        if (leftType.equals(rightType)) {
            return leftType;
        }
        boolean bl = isAllNumber = this.isNumberType(leftType.getSqlType()) && this.isNumberType(rightType.getSqlType());
        if (!isAllNumber) {
            throw new TransformException((SeaTunnelErrorCode)CommonErrorCodeDeprecated.UNSUPPORTED_OPERATION, leftType + " type not compatible " + rightType);
        }
        if (leftType.getSqlType() == SqlType.DECIMAL || rightType.getSqlType() == SqlType.DECIMAL) {
            DecimalType decimalType;
            int precision = 0;
            int scale = 0;
            if (leftType.getSqlType() == SqlType.DECIMAL) {
                decimalType = (DecimalType)leftType;
                precision = decimalType.getPrecision();
                scale = decimalType.getScale();
            }
            if (rightType.getSqlType() == SqlType.DECIMAL) {
                decimalType = (DecimalType)rightType;
                precision = Math.max(decimalType.getPrecision(), precision);
                scale = Math.max(decimalType.getScale(), scale);
            }
            return new DecimalType(precision, scale);
        }
        return leftType.getSqlType().compareTo((Enum)rightType.getSqlType()) <= 0 ? rightType : leftType;
    }

    public SeaTunnelDataType<?> getMaxType(Collection<SeaTunnelDataType<?>> types) {
        if (CollectionUtils.isEmpty(types)) {
            throw new TransformException((SeaTunnelErrorCode)CommonErrorCodeDeprecated.UNSUPPORTED_OPERATION, "getMaxType parameter is null");
        }
        Iterator<SeaTunnelDataType<?>> iterator = types.iterator();
        SeaTunnelDataType<?> result = iterator.next();
        while (iterator.hasNext()) {
            result = this.getMaxType(result, iterator.next());
        }
        return result;
    }

    private SeaTunnelDataType<?> getCaseType(CaseExpression caseExpression) {
        Collection types = caseExpression.getWhenClauses().stream().map(WhenClause::getThenExpression).map(this::getExpressionType).collect(Collectors.toSet());
        if (caseExpression.getElseExpression() != null) {
            types.add(this.getExpressionType(caseExpression.getElseExpression()));
        }
        return this.getMaxType(types);
    }

    private SeaTunnelDataType<?> getCastType(CastExpression castExpression) {
        String dataType = castExpression.getType().getDataType();
        switch (dataType.toUpperCase()) {
            case "DECIMAL": {
                List<String> ps = castExpression.getType().getArgumentsStringList();
                return new DecimalType(Integer.parseInt(ps.get(0)), Integer.parseInt(ps.get(1)));
            }
            case "VARCHAR": 
            case "STRING": {
                return BasicType.STRING_TYPE;
            }
            case "INT": 
            case "INTEGER": {
                return BasicType.INT_TYPE;
            }
            case "BIGINT": 
            case "LONG": {
                return BasicType.LONG_TYPE;
            }
            case "BYTE": {
                return BasicType.BYTE_TYPE;
            }
            case "DOUBLE": {
                return BasicType.DOUBLE_TYPE;
            }
            case "FLOAT": {
                return BasicType.FLOAT_TYPE;
            }
            case "TIMESTAMP": 
            case "DATETIME": {
                return LocalTimeType.LOCAL_DATE_TIME_TYPE;
            }
            case "DATE": {
                return LocalTimeType.LOCAL_DATE_TYPE;
            }
            case "TIME": {
                return LocalTimeType.LOCAL_TIME_TYPE;
            }
        }
        throw new TransformException((SeaTunnelErrorCode)CommonErrorCodeDeprecated.UNSUPPORTED_OPERATION, String.format("Unsupported CAST AS type: %s", dataType));
    }

    private SeaTunnelDataType<?> getFunctionType(Function function) {
        switch (function.getName().toUpperCase()) {
            case "CHAR": 
            case "CHR": 
            case "CONCAT": 
            case "CONCAT_WS": 
            case "HEXTORAW": 
            case "RAWTOHEX": 
            case "INSERT": 
            case "LOWER": 
            case "LCASE": 
            case "UPPER": 
            case "UCASE": 
            case "LEFT": 
            case "RIGHT": 
            case "LPAD": 
            case "RPAD": 
            case "LTRIM": 
            case "RTRIM": 
            case "TRIM": 
            case "REGEXP_REPLACE": 
            case "REGEXP_SUBSTR": 
            case "REPEAT": 
            case "REPLACE": 
            case "SOUNDEX": 
            case "SPACE": 
            case "SUBSTRING": 
            case "SUBSTR": 
            case "TO_CHAR": 
            case "TRANSLATE": 
            case "DAYNAME": 
            case "MONTHNAME": 
            case "FORMATDATETIME": 
            case "FROM_UNIXTIME": {
                return BasicType.STRING_TYPE;
            }
            case "ASCII": 
            case "LOCATE": 
            case "INSTR": 
            case "POSITION": 
            case "CEIL": 
            case "CEILING": 
            case "FLOOR": 
            case "DAY_OF_MONTH": 
            case "DAY_OF_WEEK": 
            case "DAY_OF_YEAR": 
            case "EXTRACT": 
            case "HOUR": 
            case "MINUTE": 
            case "MONTH": 
            case "QUARTER": 
            case "SECOND": 
            case "WEEK": 
            case "YEAR": 
            case "SIGN": {
                return BasicType.INT_TYPE;
            }
            case "BIT_LENGTH": 
            case "CHAR_LENGTH": 
            case "LENGTH": 
            case "OCTET_LENGTH": 
            case "DATEDIFF": {
                return BasicType.LONG_TYPE;
            }
            case "REGEXP_LIKE": 
            case "IS_DATE": {
                return BasicType.BOOLEAN_TYPE;
            }
            case "ACOS": 
            case "ASIN": 
            case "ATAN": 
            case "COS": 
            case "COSH": 
            case "COT": 
            case "SIN": 
            case "SINH": 
            case "TAN": 
            case "TANH": 
            case "ATAN2": 
            case "EXP": 
            case "LN": 
            case "LOG": 
            case "LOG10": 
            case "RADIANS": 
            case "SQRT": 
            case "PI": 
            case "POWER": 
            case "RAND": 
            case "RANDOM": 
            case "TRUNC": 
            case "TRUNCATE": {
                return BasicType.DOUBLE_TYPE;
            }
            case "NOW": 
            case "DATE_TRUNC": {
                return LocalTimeType.LOCAL_DATE_TIME_TYPE;
            }
            case "PARSEDATETIME": 
            case "TO_DATE": {
                String format = function.getParameters().getExpressions().get(1).toString();
                if (format.contains("yy") && format.contains("mm")) {
                    return LocalTimeType.LOCAL_DATE_TIME_TYPE;
                }
                if (format.contains("yy")) {
                    return LocalTimeType.LOCAL_DATE_TYPE;
                }
                if (format.contains("mm")) {
                    return LocalTimeType.LOCAL_TIME_TYPE;
                }
                throw new TransformException((SeaTunnelErrorCode)CommonErrorCodeDeprecated.UNSUPPORTED_OPERATION, String.format("Unknown pattern letter %s for function: %s", format, function.getName()));
            }
            case "ABS": 
            case "DATEADD": 
            case "TIMESTAMPADD": 
            case "ROUND": 
            case "NULLIF": 
            case "COALESCE": 
            case "IFNULL": {
                return this.getExpressionType(function.getParameters().getExpressions().get(0));
            }
            case "MOD": {
                return this.getExpressionType(function.getParameters().getExpressions().get(1));
            }
        }
        for (ZetaUDF udf : this.udfList) {
            List<Expression> expressions;
            if (!udf.functionName().equalsIgnoreCase(function.getName())) continue;
            ArrayList argsType = new ArrayList();
            ExpressionList expressionList = function.getParameters();
            if (expressionList != null && (expressions = expressionList.getExpressions()) != null) {
                for (Expression expression : expressions) {
                    argsType.add(this.getExpressionType(expression));
                }
            }
            return udf.resultType(argsType);
        }
        throw new TransformException((SeaTunnelErrorCode)CommonErrorCodeDeprecated.UNSUPPORTED_OPERATION, String.format("Unsupported function: %s ", function.getName()));
    }

    private SeaTunnelDataType<?> getTimeKeyExprType(TimeKeyExpression timeKeyExpression) {
        switch (timeKeyExpression.getStringValue().toUpperCase()) {
            case "CURRENT_DATE": 
            case "CURRENT_DATE()": {
                return LocalTimeType.LOCAL_DATE_TYPE;
            }
            case "CURRENT_TIME": 
            case "CURRENT_TIME()": {
                return LocalTimeType.LOCAL_TIME_TYPE;
            }
            case "CURRENT_TIMESTAMP": 
            case "CURRENT_TIMESTAMP()": {
                return LocalTimeType.LOCAL_DATE_TIME_TYPE;
            }
        }
        throw new TransformException((SeaTunnelErrorCode)CommonErrorCodeDeprecated.UNSUPPORTED_OPERATION, String.format("Unsupported TimeKey expression: %s ", timeKeyExpression.getStringValue()));
    }
}

