/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.metrics.impl;

import com.hazelcast.config.MetricsConfig;
import com.hazelcast.internal.metrics.MetricsPublisher;
import com.hazelcast.internal.metrics.MetricsRegistry;
import com.hazelcast.internal.metrics.collectors.MetricsCollector;
import com.hazelcast.internal.metrics.impl.LiveOperationRegistry;
import com.hazelcast.internal.metrics.impl.PublisherMetricsCollector;
import com.hazelcast.internal.metrics.jmx.JmxPublisher;
import com.hazelcast.internal.metrics.managementcenter.ConcurrentArrayRingbuffer;
import com.hazelcast.internal.metrics.managementcenter.ManagementCenterPublisher;
import com.hazelcast.internal.services.ManagedService;
import com.hazelcast.internal.util.ConcurrencyUtil;
import com.hazelcast.internal.util.ExceptionUtil;
import com.hazelcast.internal.util.MapUtil;
import com.hazelcast.logging.ILogger;
import com.hazelcast.spi.impl.NodeEngine;
import com.hazelcast.spi.impl.NodeEngineImpl;
import com.hazelcast.spi.impl.executionservice.ExecutionService;
import com.hazelcast.spi.impl.operationservice.LiveOperations;
import com.hazelcast.spi.impl.operationservice.LiveOperationsTracker;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public class MetricsService
implements ManagedService,
LiveOperationsTracker {
    public static final String SERVICE_NAME = "hz:impl:metricsService";
    private final NodeEngineImpl nodeEngine;
    private final ILogger logger;
    private final MetricsConfig config;
    private final LiveOperationRegistry liveOperationRegistry;
    private final ConcurrentMap<CompletableFuture<ConcurrentArrayRingbuffer.RingbufferSlice<Map.Entry<Long, byte[]>>>, Long> pendingReads = new ConcurrentHashMap<CompletableFuture<ConcurrentArrayRingbuffer.RingbufferSlice<Map.Entry<Long, byte[]>>>, Long>();
    private final CopyOnWriteArrayList<MetricsPublisher> publishers = new CopyOnWriteArrayList();
    private volatile boolean collectorScheduled;
    private ConcurrentArrayRingbuffer<Map.Entry<Long, byte[]>> metricsJournal;
    private volatile ScheduledFuture<?> scheduledFuture;
    private final Supplier<MetricsRegistry> metricsRegistrySupplier;

    public MetricsService(NodeEngine nodeEngine) {
        this(nodeEngine, ((NodeEngineImpl)nodeEngine)::getMetricsRegistry);
    }

    public MetricsService(NodeEngine nodeEngine, Supplier<MetricsRegistry> metricsRegistrySupplier) {
        this.nodeEngine = (NodeEngineImpl)nodeEngine;
        this.logger = nodeEngine.getLogger(this.getClass());
        this.config = nodeEngine.getConfig().getMetricsConfig();
        this.liveOperationRegistry = new LiveOperationRegistry();
        this.metricsRegistrySupplier = metricsRegistrySupplier;
    }

    @Override
    public void init(NodeEngine nodeEngine, Properties properties) {
        if (this.config.isEnabled()) {
            if (this.config.getManagementCenterConfig().isEnabled()) {
                this.publishers.add(this.createMcPublisher());
            }
            if (this.config.getJmxConfig().isEnabled()) {
                this.publishers.add(this.createJmxPublisher());
            }
            if (!this.publishers.isEmpty()) {
                this.scheduleMetricsCollectorIfNeeded();
            }
        } else {
            this.logger.fine("Metrics collection is disabled");
        }
    }

    public void registerPublisher(Function<NodeEngine, MetricsPublisher> registerFunction) {
        if (this.config.isEnabled()) {
            MetricsPublisher publisher = registerFunction.apply(this.nodeEngine);
            this.publishers.add(publisher);
            this.scheduleMetricsCollectorIfNeeded();
        } else {
            this.logger.fine(String.format("Custom publisher is not registered with function %s as the metrics system is disabled", registerFunction));
        }
    }

    private void scheduleMetricsCollectorIfNeeded() {
        if (!this.collectorScheduled && !this.publishers.isEmpty()) {
            this.logger.fine("Configuring metrics collection, collection interval=" + this.config.getCollectionFrequencySeconds() + " seconds, retention=" + this.config.getManagementCenterConfig().getRetentionSeconds() + " seconds, publishers=" + this.publishers.stream().map(MetricsPublisher::name).collect(Collectors.joining(", ", "[", "]")));
            ExecutionService executionService = this.nodeEngine.getExecutionService();
            this.scheduledFuture = executionService.scheduleWithRepetition("MetricsPublisher", this::collectMetrics, 1L, this.config.getCollectionFrequencySeconds(), TimeUnit.SECONDS);
            this.collectorScheduled = true;
        }
    }

    MetricsConfig getConfig() {
        return this.config;
    }

    void collectMetrics() {
        MetricsPublisher[] publishersArr = this.publishers.toArray(new MetricsPublisher[0]);
        PublisherMetricsCollector publisherCollector = new PublisherMetricsCollector(publishersArr);
        this.collectMetrics(publisherCollector);
        publisherCollector.publishCollectedMetrics();
    }

    void collectMetrics(MetricsCollector metricsCollector) {
        this.metricsRegistrySupplier.get().collect(metricsCollector);
    }

    public LiveOperationRegistry getLiveOperationRegistry() {
        return this.liveOperationRegistry;
    }

    @Override
    public void populate(LiveOperations liveOperations) {
        this.liveOperationRegistry.populate(liveOperations);
    }

    public CompletableFuture<ConcurrentArrayRingbuffer.RingbufferSlice<Map.Entry<Long, byte[]>>> readMetrics(long startSequence) {
        if (!this.config.isEnabled()) {
            throw new IllegalArgumentException("Metrics collection is not enabled");
        }
        CompletableFuture<ConcurrentArrayRingbuffer.RingbufferSlice<Map.Entry<Long, byte[]>>> future = new CompletableFuture<ConcurrentArrayRingbuffer.RingbufferSlice<Map.Entry<Long, byte[]>>>();
        future.whenCompleteAsync(ExceptionUtil.withTryCatch(this.logger, (s2, e) -> {
            Long cfr_ignored_0 = (Long)this.pendingReads.remove(future);
        }), ConcurrencyUtil.CALLER_RUNS);
        this.pendingReads.put(future, startSequence);
        this.tryCompleteRead(future, startSequence);
        return future;
    }

    private void tryCompleteRead(CompletableFuture<ConcurrentArrayRingbuffer.RingbufferSlice<Map.Entry<Long, byte[]>>> future, long sequence) {
        try {
            ConcurrentArrayRingbuffer.RingbufferSlice<Map.Entry<Long, byte[]>> slice = this.metricsJournal.copyFrom(sequence);
            if (!slice.isEmpty()) {
                future.complete(slice);
            }
        }
        catch (Exception e) {
            this.logger.severe("Error reading from metrics journal, sequence: " + sequence, e);
            future.completeExceptionally(e);
        }
    }

    @Override
    public void reset() {
    }

    @Override
    public void shutdown(boolean terminate) {
        if (this.scheduledFuture != null) {
            this.scheduledFuture.cancel(false);
        }
        this.publishers.forEach(MetricsPublisher::shutdown);
    }

    private JmxPublisher createJmxPublisher() {
        return new JmxPublisher(this.nodeEngine.getHazelcastInstance().getName(), "com.hazelcast");
    }

    private ManagementCenterPublisher createMcPublisher() {
        int retentionSeconds = this.config.getManagementCenterConfig().getRetentionSeconds();
        int frequency = this.config.getCollectionFrequencySeconds();
        int journalSize = Math.max(1, (int)Math.ceil((double)retentionSeconds / (double)frequency));
        this.metricsJournal = new ConcurrentArrayRingbuffer(journalSize);
        return new ManagementCenterPublisher(this.nodeEngine.getLoggingService(), (blob, ts) -> {
            this.metricsJournal.add(MapUtil.entry(ts, blob));
            this.pendingReads.forEach(this::tryCompleteRead);
        });
    }
}

