/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.metrics.impl;

import com.hazelcast.internal.metrics.MetricDescriptor;
import com.hazelcast.internal.metrics.MetricTarget;
import com.hazelcast.internal.metrics.ProbeFunction;
import com.hazelcast.internal.metrics.ProbeLevel;
import com.hazelcast.internal.metrics.impl.CachedProbe;
import com.hazelcast.internal.metrics.impl.FieldProbe;
import com.hazelcast.internal.metrics.impl.MethodProbe;
import com.hazelcast.internal.metrics.impl.SourceMetadata;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;

final class MetricsUtil {
    private MetricsUtil() {
    }

    static void adjustExclusionsWithLevel(MetricDescriptor descriptor, ProbeLevel level) {
        if (ProbeLevel.DEBUG != level) {
            return;
        }
        if (descriptor.excludedTargets().contains((Object)MetricTarget.DIAGNOSTICS)) {
            descriptor.withExcludedTargets(MetricTarget.ALL_TARGETS);
        } else {
            descriptor.withExcludedTargets(MetricTarget.ALL_TARGETS_BUT_DIAGNOSTICS);
        }
    }

    static Collection<MetricTarget> extractExcludedTargets(ProbeFunction function) {
        if (function instanceof FieldProbe) {
            FieldProbe fieldProbe = (FieldProbe)function;
            return MetricsUtil.extractExcludedTargets(fieldProbe.probe, fieldProbe.sourceMetadata);
        }
        if (function instanceof MethodProbe) {
            MethodProbe methodProbe = (MethodProbe)function;
            return MetricsUtil.extractExcludedTargets(methodProbe.probe, methodProbe.sourceMetadata);
        }
        return Collections.emptySet();
    }

    private static Collection<MetricTarget> extractExcludedTargets(CachedProbe probe, SourceMetadata sourceMetadata) {
        ProbeLevel level = probe.level();
        Collection<MetricTarget> excludedTargetsClass = sourceMetadata.excludedTargetsClass();
        Set<MetricTarget> excludedTargetsProbe = MetricTarget.asSet(probe.excludedTargets());
        Set<MetricTarget> excludedTargetsUnion = MetricTarget.union(excludedTargetsClass, excludedTargetsProbe);
        if (ProbeLevel.DEBUG != level) {
            return excludedTargetsUnion;
        }
        if (excludedTargetsUnion.contains((Object)MetricTarget.DIAGNOSTICS)) {
            return MetricTarget.ALL_TARGETS;
        }
        return MetricTarget.ALL_TARGETS_BUT_DIAGNOSTICS;
    }
}

