/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.metrics.impl;

import com.hazelcast.internal.metrics.ExcludedMetricTargets;
import com.hazelcast.internal.metrics.MetricTarget;
import com.hazelcast.internal.metrics.Probe;
import com.hazelcast.internal.metrics.impl.FieldProbe;
import com.hazelcast.internal.metrics.impl.MethodProbe;
import com.hazelcast.internal.metrics.impl.MetricsRegistryImpl;
import com.hazelcast.internal.metrics.impl.ProbeUtils;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

final class SourceMetadata {
    private final List<FieldProbe> fields = new ArrayList<FieldProbe>();
    private final List<MethodProbe> methods = new ArrayList<MethodProbe>();
    private final Collection<MetricTarget> excludedTargetsClass;

    SourceMetadata(Class clazz) {
        ArrayList classList = new ArrayList();
        ProbeUtils.flatten(clazz, classList);
        for (Class clazz2 : classList) {
            this.scanFields(clazz2);
            this.scanMethods(clazz2);
        }
        this.excludedTargetsClass = this.getTypeExcludedTarget(clazz);
    }

    void register(MetricsRegistryImpl metricsRegistry, Object source, String namePrefix) {
        for (FieldProbe field2 : this.fields) {
            field2.register(metricsRegistry, source, namePrefix);
        }
        for (MethodProbe method : this.methods) {
            method.register(metricsRegistry, source, namePrefix);
        }
    }

    private Collection<MetricTarget> getTypeExcludedTarget(Class clazz) {
        ExcludedMetricTargets targetsAnnotation = clazz.getAnnotation(ExcludedMetricTargets.class);
        List<MetricTarget> typeExclusions = targetsAnnotation != null ? Collections.unmodifiableList(Arrays.asList(targetsAnnotation.value())) : Collections.emptyList();
        return typeExclusions;
    }

    private void scanFields(Class<?> clazz) {
        for (Field field2 : clazz.getDeclaredFields()) {
            Probe probe = field2.getAnnotation(Probe.class);
            if (probe == null) continue;
            FieldProbe fieldProbe = FieldProbe.createFieldProbe(field2, probe, this);
            this.fields.add(fieldProbe);
        }
    }

    private void scanMethods(Class<?> clazz) {
        for (Method method : clazz.getDeclaredMethods()) {
            Probe probe = method.getAnnotation(Probe.class);
            if (probe == null) continue;
            MethodProbe methodProbe = MethodProbe.createMethodProbe(method, probe, this);
            this.methods.add(methodProbe);
        }
    }

    public List<FieldProbe> fields() {
        return this.fields;
    }

    public List<MethodProbe> methods() {
        return this.methods;
    }

    public Collection<MetricTarget> excludedTargetsClass() {
        return this.excludedTargetsClass;
    }
}

