/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl.operation;

import com.hazelcast.internal.nio.IOUtil;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.jet.config.JobConfig;
import com.hazelcast.jet.impl.operation.AsyncJobOperation;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import javax.security.auth.Subject;

public class SubmitJobOperation
extends AsyncJobOperation {
    private Data jobDefinition;
    private Data serializedConfig;
    private boolean isLightJob;
    private Subject subject;

    public SubmitJobOperation() {
    }

    public SubmitJobOperation(long jobId, Data jobDefinition, Data config, boolean isLightJob) {
        this(jobId, jobDefinition, config, isLightJob, null);
    }

    public SubmitJobOperation(long jobId, Data jobDefinition, Data config, boolean isLightJob, Subject subject) {
        super(jobId);
        this.jobDefinition = jobDefinition;
        this.serializedConfig = config;
        this.isLightJob = isLightJob;
        this.subject = subject;
    }

    public CompletableFuture<Void> doRun() {
        JobConfig jobConfig = (JobConfig)this.getNodeEngine().getSerializationService().toObject(this.serializedConfig);
        if (this.isLightJob) {
            return this.getJobCoordinationService().submitLightJob(this.jobId(), this.jobDefinition, jobConfig, this.subject);
        }
        return this.getJobCoordinationService().submitJob(this.jobId(), this.jobDefinition, jobConfig, this.subject);
    }

    @Override
    public int getClassId() {
        return 8;
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        IOUtil.writeData(out, this.jobDefinition);
        IOUtil.writeData(out, this.serializedConfig);
        out.writeBoolean(this.isLightJob);
        out.writeObject(this.subject);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.jobDefinition = IOUtil.readData(in);
        this.serializedConfig = IOUtil.readData(in);
        this.isLightJob = in.readBoolean();
        this.subject = (Subject)in.readObject();
    }
}

