/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.org.everit.json.schema;

import com.hazelcast.org.everit.json.schema.FormatValidator;
import com.hazelcast.org.everit.json.schema.StringSchema;
import com.hazelcast.org.everit.json.schema.ValidatingVisitor;
import com.hazelcast.org.everit.json.schema.Visitor;
import com.hazelcast.org.everit.json.schema.regexp.Regexp;
import java.util.Objects;
import java.util.Optional;

public class StringSchemaValidatingVisitor
extends Visitor {
    private final Object subject;
    private String stringSubject;
    private int stringLength;
    private final ValidatingVisitor owner;

    public StringSchemaValidatingVisitor(Object subject, ValidatingVisitor owner) {
        this.subject = subject;
        this.owner = Objects.requireNonNull(owner, "failureReporter cannot be null");
    }

    @Override
    void visitStringSchema(StringSchema stringSchema) {
        this.owner.ifPassesTypeCheck(String.class, stringSchema.requireString(), stringSchema.isNullable(), stringSubject -> {
            this.stringSubject = stringSubject;
            this.stringLength = stringSubject.codePointCount(0, stringSubject.length());
            super.visitStringSchema(stringSchema);
        });
    }

    @Override
    void visitMinLength(Integer minLength) {
        if (minLength != null && this.stringLength < minLength) {
            this.owner.failure("expected minLength: " + minLength + ", actual: " + this.stringLength, "minLength");
        }
    }

    @Override
    void visitMaxLength(Integer maxLength) {
        if (maxLength != null && this.stringLength > maxLength) {
            this.owner.failure("expected maxLength: " + maxLength + ", actual: " + this.stringLength, "maxLength");
        }
    }

    @Override
    void visitPattern(Regexp pattern) {
        if (pattern != null && pattern.patternMatchingFailure(this.stringSubject).isPresent()) {
            String message = String.format("string [%s] does not match pattern %s", this.subject, pattern.toString());
            this.owner.failure(message, "pattern");
        }
    }

    @Override
    void visitFormat(FormatValidator formatValidator) {
        Optional<String> failure = formatValidator.validate(this.stringSubject);
        if (failure.isPresent()) {
            this.owner.failure(failure.get(), "format");
        }
    }
}

