/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.api.sink;

import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.seatunnel.api.common.SeaTunnelAPIErrorCode;
import org.apache.seatunnel.api.sink.DataSaveMode;
import org.apache.seatunnel.api.sink.SaveModeHandler;
import org.apache.seatunnel.api.sink.SchemaSaveMode;
import org.apache.seatunnel.api.table.catalog.Catalog;
import org.apache.seatunnel.api.table.catalog.CatalogTable;
import org.apache.seatunnel.api.table.catalog.TablePath;
import org.apache.seatunnel.common.exception.SeaTunnelErrorCode;
import org.apache.seatunnel.common.exception.SeaTunnelRuntimeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultSaveModeHandler
implements SaveModeHandler {
    private static final Logger log = LoggerFactory.getLogger(DefaultSaveModeHandler.class);
    @Nonnull
    public SchemaSaveMode schemaSaveMode;
    @Nonnull
    public DataSaveMode dataSaveMode;
    @Nonnull
    public Catalog catalog;
    @Nonnull
    public TablePath tablePath;
    @Nullable
    public CatalogTable catalogTable;
    @Nullable
    public String customSql;

    public DefaultSaveModeHandler(SchemaSaveMode schemaSaveMode, DataSaveMode dataSaveMode, Catalog catalog, CatalogTable catalogTable, String customSql) {
        this(schemaSaveMode, dataSaveMode, catalog, catalogTable.getTableId().toTablePath(), catalogTable, customSql);
    }

    @Override
    public void open() {
        this.catalog.open();
    }

    @Override
    public void handleSchemaSaveMode() {
        switch (this.schemaSaveMode) {
            case RECREATE_SCHEMA: {
                this.recreateSchema();
                break;
            }
            case CREATE_SCHEMA_WHEN_NOT_EXIST: {
                this.createSchemaWhenNotExist();
                break;
            }
            case ERROR_WHEN_SCHEMA_NOT_EXIST: {
                this.errorWhenSchemaNotExist();
                break;
            }
            case IGNORE: {
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported save mode: " + (Object)((Object)this.schemaSaveMode));
            }
        }
    }

    @Override
    public void handleDataSaveMode() {
        switch (this.dataSaveMode) {
            case DROP_DATA: {
                this.keepSchemaDropData();
                break;
            }
            case APPEND_DATA: {
                this.keepSchemaAndData();
                break;
            }
            case CUSTOM_PROCESSING: {
                this.customProcessing();
                break;
            }
            case ERROR_WHEN_DATA_EXISTS: {
                this.errorWhenDataExists();
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported save mode: " + (Object)((Object)this.dataSaveMode));
            }
        }
    }

    protected void recreateSchema() {
        if (this.tableExists()) {
            this.dropTable();
        }
        this.createTable();
    }

    protected void createSchemaWhenNotExist() {
        if (!this.tableExists()) {
            this.createTable();
        }
    }

    protected void errorWhenSchemaNotExist() {
        if (!this.tableExists()) {
            throw new SeaTunnelRuntimeException((SeaTunnelErrorCode)SeaTunnelAPIErrorCode.SINK_TABLE_NOT_EXIST, "The sink table not exist");
        }
    }

    protected void keepSchemaDropData() {
        if (this.tableExists()) {
            this.truncateTable();
        }
    }

    protected void keepSchemaAndData() {
    }

    protected void customProcessing() {
        this.executeCustomSql();
    }

    protected void errorWhenDataExists() {
        if (this.dataExists()) {
            throw new SeaTunnelRuntimeException((SeaTunnelErrorCode)SeaTunnelAPIErrorCode.SOURCE_ALREADY_HAS_DATA, "The target data source already has data");
        }
    }

    protected boolean tableExists() {
        return this.catalog.tableExists(this.tablePath);
    }

    protected void dropTable() {
        try {
            log.info("Dropping table {} with action {}", (Object)this.tablePath, (Object)this.catalog.previewAction(Catalog.ActionType.DROP_TABLE, this.tablePath, Optional.empty()));
        }
        catch (UnsupportedOperationException ignore) {
            log.info("Dropping table {}", (Object)this.tablePath);
        }
        this.catalog.dropTable(this.tablePath, true);
    }

    protected void createTablePreCheck() {
        if (!this.catalog.databaseExists(this.tablePath.getDatabaseName())) {
            try {
                log.info("Creating database {} with action {}", (Object)this.tablePath.getDatabaseName(), (Object)this.catalog.previewAction(Catalog.ActionType.CREATE_DATABASE, this.tablePath, Optional.empty()));
            }
            catch (UnsupportedOperationException ignore) {
                log.info("Creating database {}", (Object)this.tablePath.getDatabaseName());
            }
            this.catalog.createDatabase(this.tablePath, true);
        }
        try {
            log.info("Creating table {} with action {}", (Object)this.tablePath, (Object)this.catalog.previewAction(Catalog.ActionType.CREATE_TABLE, this.tablePath, Optional.ofNullable(this.catalogTable)));
        }
        catch (UnsupportedOperationException ignore) {
            log.info("Creating table {}", (Object)this.tablePath);
        }
    }

    protected void createTable() {
        this.createTablePreCheck();
        this.catalog.createTable(this.tablePath, this.catalogTable, true);
    }

    protected void truncateTable() {
        try {
            log.info("Truncating table {} with action {}", (Object)this.tablePath, (Object)this.catalog.previewAction(Catalog.ActionType.TRUNCATE_TABLE, this.tablePath, Optional.empty()));
        }
        catch (UnsupportedOperationException ignore) {
            log.info("Truncating table {}", (Object)this.tablePath);
        }
        this.catalog.truncateTable(this.tablePath, true);
    }

    protected boolean dataExists() {
        return this.catalog.isExistsData(this.tablePath);
    }

    protected void executeCustomSql() {
        log.info("Executing custom SQL for table {} with SQL: {}", (Object)this.tablePath, (Object)this.customSql);
        this.catalog.executeSql(this.tablePath, this.customSql);
    }

    @Override
    public TablePath getHandleTablePath() {
        return this.tablePath;
    }

    @Override
    public Catalog getHandleCatalog() {
        return this.catalog;
    }

    @Override
    public SchemaSaveMode getSchemaSaveMode() {
        return this.schemaSaveMode;
    }

    @Override
    public DataSaveMode getDataSaveMode() {
        return this.dataSaveMode;
    }

    @Override
    public void close() throws Exception {
        this.catalog.close();
    }

    public DefaultSaveModeHandler(@Nonnull SchemaSaveMode schemaSaveMode, @Nonnull DataSaveMode dataSaveMode, @Nonnull Catalog catalog, @Nonnull TablePath tablePath, @Nullable CatalogTable catalogTable, @Nullable String customSql) {
        if (schemaSaveMode == null) {
            throw new NullPointerException("schemaSaveMode is marked non-null but is null");
        }
        if (dataSaveMode == null) {
            throw new NullPointerException("dataSaveMode is marked non-null but is null");
        }
        if (catalog == null) {
            throw new NullPointerException("catalog is marked non-null but is null");
        }
        if (tablePath == null) {
            throw new NullPointerException("tablePath is marked non-null but is null");
        }
        this.schemaSaveMode = schemaSaveMode;
        this.dataSaveMode = dataSaveMode;
        this.catalog = catalog;
        this.tablePath = tablePath;
        this.catalogTable = catalogTable;
        this.customSql = customSql;
    }
}

