/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.api.table.catalog;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.seatunnel.api.common.CommonOptions;
import org.apache.seatunnel.api.configuration.ReadonlyConfig;
import org.apache.seatunnel.api.table.catalog.Catalog;
import org.apache.seatunnel.api.table.catalog.CatalogTable;
import org.apache.seatunnel.api.table.catalog.Column;
import org.apache.seatunnel.api.table.catalog.PhysicalColumn;
import org.apache.seatunnel.api.table.catalog.TableIdentifier;
import org.apache.seatunnel.api.table.catalog.TablePath;
import org.apache.seatunnel.api.table.catalog.TableSchema;
import org.apache.seatunnel.api.table.catalog.schema.ReadonlyConfigParser;
import org.apache.seatunnel.api.table.catalog.schema.TableSchemaOptions;
import org.apache.seatunnel.api.table.factory.FactoryUtil;
import org.apache.seatunnel.api.table.type.BasicType;
import org.apache.seatunnel.api.table.type.MultipleRowType;
import org.apache.seatunnel.api.table.type.SeaTunnelDataType;
import org.apache.seatunnel.api.table.type.SeaTunnelRow;
import org.apache.seatunnel.api.table.type.SeaTunnelRowType;
import org.apache.seatunnel.common.utils.SeaTunnelException;
import org.apache.seatunnel.shade.com.typesafe.config.Config;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CatalogTableUtil
implements Serializable {
    private static final Logger log = LoggerFactory.getLogger(CatalogTableUtil.class);
    private static final SeaTunnelRowType SIMPLE_SCHEMA = new SeaTunnelRowType(new String[]{"content"}, new SeaTunnelDataType[]{BasicType.STRING_TYPE});

    @Deprecated
    public static CatalogTable getCatalogTable(String tableName, SeaTunnelRowType rowType) {
        return CatalogTableUtil.getCatalogTable("schema", "default", null, tableName, rowType);
    }

    public static CatalogTable getCatalogTable(String catalog, String database, String schema, String tableName, SeaTunnelRowType rowType) {
        TableSchema.Builder schemaBuilder = TableSchema.builder();
        for (int i = 0; i < rowType.getTotalFields(); ++i) {
            PhysicalColumn column = PhysicalColumn.of(rowType.getFieldName(i), rowType.getFieldType(i), 0, true, null, null);
            schemaBuilder.column(column);
        }
        return CatalogTable.of(TableIdentifier.of(catalog, database, schema, tableName), schemaBuilder.build(), new HashMap<String, String>(), new ArrayList<String>(), "It is converted from RowType and only has column information.");
    }

    @Deprecated
    public static List<CatalogTable> getCatalogTables(ReadonlyConfig readonlyConfig, ClassLoader classLoader) {
        String factoryId = readonlyConfig.get(CommonOptions.PLUGIN_NAME).replace("-CDC", "");
        return CatalogTableUtil.getCatalogTables(factoryId, readonlyConfig, classLoader);
    }

    @Deprecated
    public static List<CatalogTable> getCatalogTables(String factoryId, ReadonlyConfig readonlyConfig, ClassLoader classLoader) {
        Map<String, Object> schemaMap = readonlyConfig.get(TableSchemaOptions.SCHEMA);
        if (schemaMap != null) {
            if (schemaMap.isEmpty()) {
                throw new SeaTunnelException("Schema config can not be empty");
            }
            CatalogTable catalogTable = CatalogTableUtil.buildWithConfig(factoryId, readonlyConfig);
            return Collections.singletonList(catalogTable);
        }
        Optional<Catalog> optionalCatalog = FactoryUtil.createOptionalCatalog(factoryId, readonlyConfig, classLoader, factoryId);
        return optionalCatalog.map(c -> {
            try (Catalog catalog = c;){
                long startTime = System.currentTimeMillis();
                catalog.open();
                List<CatalogTable> catalogTables = catalog.getTables(readonlyConfig);
                log.info(String.format("Get catalog tables, cost time: %d ms", System.currentTimeMillis() - startTime));
                if (catalogTables.isEmpty()) {
                    throw new SeaTunnelException(String.format("Can not find catalog table with factoryId [%s]", factoryId));
                }
                List<CatalogTable> list = catalogTables;
                return list;
            }
        }).orElseThrow(() -> new SeaTunnelException(String.format("Can not find catalog with factoryId [%s]", factoryId)));
    }

    public static CatalogTable buildWithConfig(Config config) {
        ReadonlyConfig readonlyConfig = ReadonlyConfig.fromConfig(config);
        return CatalogTableUtil.buildWithConfig(readonlyConfig);
    }

    public static SeaTunnelDataType<SeaTunnelRow> convertToDataType(List<CatalogTable> catalogTables) {
        if (catalogTables.size() == 1) {
            return catalogTables.get(0).getTableSchema().toPhysicalRowDataType();
        }
        return CatalogTableUtil.convertToMultipleRowType(catalogTables);
    }

    public static MultipleRowType convertToMultipleRowType(List<CatalogTable> catalogTables) {
        HashMap<String, SeaTunnelRowType> rowTypeMap = new HashMap<String, SeaTunnelRowType>();
        for (CatalogTable catalogTable : catalogTables) {
            String tableId = catalogTable.getTableId().toTablePath().toString();
            rowTypeMap.put(tableId, catalogTable.getTableSchema().toPhysicalRowDataType());
        }
        return new MultipleRowType(rowTypeMap);
    }

    @Deprecated
    public static List<CatalogTable> convertDataTypeToCatalogTables(SeaTunnelDataType<?> seaTunnelDataType, String tableId) {
        ArrayList<CatalogTable> catalogTables;
        if (seaTunnelDataType instanceof MultipleRowType) {
            catalogTables = new ArrayList();
            for (String id : ((MultipleRowType)seaTunnelDataType).getTableIds()) {
                catalogTables.add(CatalogTableUtil.getCatalogTable(id, ((MultipleRowType)seaTunnelDataType).getRowType(id)));
            }
        } else {
            catalogTables = Collections.singletonList(CatalogTableUtil.getCatalogTable(tableId, (SeaTunnelRowType)seaTunnelDataType));
        }
        return catalogTables;
    }

    public static CatalogTable buildWithConfig(ReadonlyConfig readonlyConfig) {
        return CatalogTableUtil.buildWithConfig("", readonlyConfig);
    }

    public static CatalogTable buildWithConfig(String catalogName, ReadonlyConfig readonlyConfig) {
        TablePath tablePath;
        if (readonlyConfig.get(TableSchemaOptions.SCHEMA) == null) {
            throw new RuntimeException("Schema config need option [schema], please correct your config first");
        }
        TableSchema tableSchema = new ReadonlyConfigParser().parse(readonlyConfig);
        ReadonlyConfig schemaConfig = readonlyConfig.getOptional(TableSchemaOptions.SCHEMA).map(ReadonlyConfig::fromMap).orElseThrow(() -> new IllegalArgumentException("Schema config can't be null"));
        if (StringUtils.isNotEmpty(schemaConfig.get(TableSchemaOptions.TableIdentifierOptions.TABLE))) {
            tablePath = TablePath.of(schemaConfig.get(TableSchemaOptions.TableIdentifierOptions.TABLE), schemaConfig.get(TableSchemaOptions.TableIdentifierOptions.SCHEMA_FIRST));
        } else {
            Optional<String> resultTableNameOptional = readonlyConfig.getOptional(CommonOptions.RESULT_TABLE_NAME);
            tablePath = resultTableNameOptional.map(TablePath::of).orElse(TablePath.DEFAULT);
        }
        return CatalogTable.of(TableIdentifier.of(catalogName, tablePath), tableSchema, new HashMap<String, String>(), new ArrayList<String>(), readonlyConfig.get(TableSchemaOptions.TableIdentifierOptions.COMMENT));
    }

    public static SeaTunnelRowType buildSimpleTextSchema() {
        return SIMPLE_SCHEMA;
    }

    public static CatalogTable buildSimpleTextTable() {
        return CatalogTableUtil.getCatalogTable("default", CatalogTableUtil.buildSimpleTextSchema());
    }

    public static CatalogTable newCatalogTable(CatalogTable catalogTable, SeaTunnelRowType seaTunnelRowType) {
        TableSchema tableSchema = catalogTable.getTableSchema();
        Map columnMap = tableSchema.getColumns().stream().collect(Collectors.toMap(Column::getName, Function.identity()));
        String[] fieldNames = seaTunnelRowType.getFieldNames();
        SeaTunnelDataType<?>[] fieldTypes = seaTunnelRowType.getFieldTypes();
        ArrayList<Column> finalColumns = new ArrayList<Column>();
        for (int i = 0; i < fieldNames.length; ++i) {
            Column column = (Column)columnMap.get(fieldNames[i]);
            if (column != null) {
                finalColumns.add(column);
                continue;
            }
            finalColumns.add(PhysicalColumn.of(fieldNames[i], fieldTypes[i], 0, false, null, null));
        }
        TableSchema finalSchema = TableSchema.builder().columns(finalColumns).primaryKey(tableSchema.getPrimaryKey()).constraintKey(tableSchema.getConstraintKeys()).build();
        return CatalogTable.of(catalogTable.getTableId(), finalSchema, catalogTable.getOptions(), catalogTable.getPartitionKeys(), catalogTable.getComment(), catalogTable.getCatalogName());
    }
}

