/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.api.table.catalog;

import org.apache.seatunnel.api.table.type.ArrayType;
import org.apache.seatunnel.api.table.type.BasicType;
import org.apache.seatunnel.api.table.type.DecimalType;
import org.apache.seatunnel.api.table.type.LocalTimeType;
import org.apache.seatunnel.api.table.type.MapType;
import org.apache.seatunnel.api.table.type.PrimitiveByteArrayType;
import org.apache.seatunnel.api.table.type.SeaTunnelDataType;
import org.apache.seatunnel.api.table.type.SeaTunnelRowType;
import org.apache.seatunnel.api.table.type.SqlType;
import org.apache.seatunnel.api.table.type.VectorType;
import org.apache.seatunnel.common.exception.CommonError;
import org.apache.seatunnel.shade.com.typesafe.config.Config;
import org.apache.seatunnel.shade.com.typesafe.config.ConfigFactory;
import org.apache.seatunnel.shade.com.typesafe.config.ConfigObject;
import org.apache.seatunnel.shade.com.typesafe.config.ConfigValue;

public class SeaTunnelDataTypeConvertorUtil {
    public static SeaTunnelDataType<?> deserializeSeaTunnelDataType(String field2, String columnType) {
        Enum sqlType = null;
        try {
            String compatible = SeaTunnelDataTypeConvertorUtil.compatibleTypeDeclare(columnType);
            sqlType = SqlType.valueOf(compatible.toUpperCase().replace(" ", ""));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        if (sqlType == null) {
            return SeaTunnelDataTypeConvertorUtil.parseComplexDataType(field2, columnType);
        }
        switch (1.$SwitchMap$org$apache$seatunnel$api$table$type$SqlType[sqlType.ordinal()]) {
            case 1: {
                return BasicType.STRING_TYPE;
            }
            case 2: {
                return BasicType.BOOLEAN_TYPE;
            }
            case 3: {
                return BasicType.BYTE_TYPE;
            }
            case 4: {
                return PrimitiveByteArrayType.INSTANCE;
            }
            case 5: {
                return BasicType.SHORT_TYPE;
            }
            case 6: {
                return BasicType.INT_TYPE;
            }
            case 7: {
                return BasicType.LONG_TYPE;
            }
            case 8: {
                return BasicType.FLOAT_TYPE;
            }
            case 9: {
                return BasicType.DOUBLE_TYPE;
            }
            case 10: {
                return BasicType.VOID_TYPE;
            }
            case 11: {
                return LocalTimeType.LOCAL_DATE_TYPE;
            }
            case 12: {
                return LocalTimeType.LOCAL_TIME_TYPE;
            }
            case 13: {
                return LocalTimeType.LOCAL_DATE_TIME_TYPE;
            }
            case 14: {
                return SeaTunnelDataTypeConvertorUtil.parseMapType(field2, columnType);
            }
            case 15: {
                return VectorType.VECTOR_BINARY_TYPE;
            }
            case 16: {
                return VectorType.VECTOR_FLOAT_TYPE;
            }
            case 17: {
                return VectorType.VECTOR_FLOAT16_TYPE;
            }
            case 18: {
                return VectorType.VECTOR_BFLOAT16_TYPE;
            }
            case 19: {
                return VectorType.VECTOR_SPARSE_FLOAT_TYPE;
            }
        }
        throw CommonError.unsupportedDataType("SeaTunnel", columnType, field2);
    }

    @Deprecated
    private static String compatibleTypeDeclare(String declare) {
        switch (declare.trim().toUpperCase()) {
            case "LONG": {
                return "BIGINT";
            }
            case "SHORT": {
                return "SMALLINT";
            }
            case "BYTE": {
                return "TINYINT";
            }
        }
        return declare;
    }

    private static SeaTunnelDataType<?> parseComplexDataType(String field2, String columnStr) {
        String column = columnStr.toUpperCase().replace(" ", "");
        if (column.startsWith(SqlType.MAP.name())) {
            return SeaTunnelDataTypeConvertorUtil.parseMapType(field2, columnStr);
        }
        if (column.startsWith(SqlType.ARRAY.name())) {
            return SeaTunnelDataTypeConvertorUtil.parseArrayType(field2, columnStr);
        }
        if (column.startsWith(SqlType.DECIMAL.name())) {
            return SeaTunnelDataTypeConvertorUtil.parseDecimalType(columnStr);
        }
        if (column.trim().startsWith("{")) {
            return SeaTunnelDataTypeConvertorUtil.parseRowType(columnStr);
        }
        throw CommonError.unsupportedDataType("SeaTunnel", columnStr, field2);
    }

    private static SeaTunnelDataType<?> parseRowType(String columnStr) {
        Config conf;
        String confPayload = "{conf = " + columnStr + "}";
        try {
            conf = ConfigFactory.parseString(confPayload);
        }
        catch (RuntimeException e) {
            throw new IllegalArgumentException(String.format("HOCON Config parse from %s failed.", confPayload), e);
        }
        return SeaTunnelDataTypeConvertorUtil.parseRowType(conf.getObject("conf"));
    }

    private static SeaTunnelDataType<?> parseRowType(ConfigObject conf) {
        String[] fieldNames = new String[conf.size()];
        SeaTunnelDataType[] fieldTypes = new SeaTunnelDataType[conf.size()];
        conf.keySet().toArray(fieldNames);
        block4: for (int idx = 0; idx < fieldNames.length; ++idx) {
            String fieldName = fieldNames[idx];
            ConfigValue typeVal = conf.get(fieldName);
            switch (typeVal.valueType()) {
                case STRING: {
                    fieldTypes[idx] = SeaTunnelDataTypeConvertorUtil.deserializeSeaTunnelDataType(fieldNames[idx], (String)typeVal.unwrapped());
                    continue block4;
                }
                case OBJECT: {
                    fieldTypes[idx] = SeaTunnelDataTypeConvertorUtil.parseRowType((ConfigObject)typeVal);
                    continue block4;
                }
                default: {
                    throw new IllegalArgumentException(String.format("Unsupported parse SeaTunnel Type from '%s'.", typeVal.unwrapped()));
                }
            }
        }
        return new SeaTunnelRowType(fieldNames, fieldTypes);
    }

    private static SeaTunnelDataType<?> parseMapType(String field2, String columnStr) {
        String genericType = SeaTunnelDataTypeConvertorUtil.getGenericType(columnStr).trim();
        int index = genericType.toUpperCase().startsWith(SqlType.DECIMAL.name()) ? genericType.indexOf(",", genericType.indexOf(",") + 1) : genericType.indexOf(",");
        String keyGenericType = genericType.substring(0, index).trim();
        String valueGenericType = genericType.substring(index + 1).trim();
        return new MapType(SeaTunnelDataTypeConvertorUtil.deserializeSeaTunnelDataType(field2, keyGenericType), SeaTunnelDataTypeConvertorUtil.deserializeSeaTunnelDataType(field2, valueGenericType));
    }

    private static String getGenericType(String columnStr) {
        return columnStr.substring(columnStr.indexOf("<") + 1, columnStr.lastIndexOf(">"));
    }

    private static SeaTunnelDataType<?> parseArrayType(String field2, String columnStr) {
        String genericType = SeaTunnelDataTypeConvertorUtil.getGenericType(columnStr).trim();
        SeaTunnelDataType<?> dataType = SeaTunnelDataTypeConvertorUtil.deserializeSeaTunnelDataType(field2, genericType);
        switch (dataType.getSqlType()) {
            case STRING: {
                return ArrayType.STRING_ARRAY_TYPE;
            }
            case BOOLEAN: {
                return ArrayType.BOOLEAN_ARRAY_TYPE;
            }
            case TINYINT: {
                return ArrayType.BYTE_ARRAY_TYPE;
            }
            case SMALLINT: {
                return ArrayType.SHORT_ARRAY_TYPE;
            }
            case INT: {
                return ArrayType.INT_ARRAY_TYPE;
            }
            case BIGINT: {
                return ArrayType.LONG_ARRAY_TYPE;
            }
            case FLOAT: {
                return ArrayType.FLOAT_ARRAY_TYPE;
            }
            case DOUBLE: {
                return ArrayType.DOUBLE_ARRAY_TYPE;
            }
        }
        throw CommonError.unsupportedDataType("SeaTunnel", genericType, field2);
    }

    private static SeaTunnelDataType<?> parseDecimalType(String columnStr) {
        String[] decimalInfos = columnStr.split(",");
        if (decimalInfos.length < 2) {
            throw new RuntimeException("Decimal type should assign precision and scale information");
        }
        int precision = Integer.parseInt(decimalInfos[0].replaceAll("\\D", ""));
        int scale = Integer.parseInt(decimalInfos[1].replaceAll("\\D", ""));
        return new DecimalType(precision, scale);
    }
}

