/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.core.starter.flowcontrol;

import java.util.Optional;
import org.apache.seatunnel.api.table.type.SeaTunnelRow;
import org.apache.seatunnel.core.starter.flowcontrol.FlowControlStrategy;
import org.apache.seatunnel.shade.com.google.common.util.concurrent.RateLimiter;

public class FlowControlGate {
    private static final int DEFAULT_VALUE = Integer.MAX_VALUE;
    private final Optional<RateLimiter> bytesRateLimiter;
    private final Optional<RateLimiter> countRateLimiter;

    private FlowControlGate(FlowControlStrategy flowControlStrategy) {
        int bytesPerSecond = flowControlStrategy.getBytesPerSecond();
        int countPerSecond = flowControlStrategy.getCountPerSecond();
        this.bytesRateLimiter = bytesPerSecond == Integer.MAX_VALUE ? Optional.empty() : Optional.of(RateLimiter.create(bytesPerSecond));
        this.countRateLimiter = countPerSecond == Integer.MAX_VALUE ? Optional.empty() : Optional.of(RateLimiter.create(countPerSecond));
    }

    public void audit(SeaTunnelRow row) {
        this.bytesRateLimiter.ifPresent(rateLimiter -> rateLimiter.acquire(row.getBytesSize()));
        this.countRateLimiter.ifPresent(RateLimiter::acquire);
    }

    public static FlowControlGate create(FlowControlStrategy flowControlStrategy) {
        return new FlowControlGate(flowControlStrategy);
    }
}

