/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.core.starter.seatunnel.args;

import com.beust.jcommander.IStringConverter;
import com.beust.jcommander.Parameter;
import org.apache.seatunnel.common.constants.PluginType;
import org.apache.seatunnel.core.starter.command.Command;
import org.apache.seatunnel.core.starter.command.CommandArgs;
import org.apache.seatunnel.core.starter.seatunnel.command.ConnectorCheckCommand;

public class ConnectorCheckCommandArgs
extends CommandArgs {
    @Parameter(names={"-l", "--list"}, description="List all supported plugins(sources, sinks, transforms)")
    private boolean listConnectors = false;
    @Parameter(names={"-o", "--option-rule"}, description="Get option rule of the plugin by the plugin identifier(connector name or transform name)")
    private String pluginIdentifier;
    @Parameter(names={"-pt", "--plugin-type"}, description="SeaTunnel plugin type, support [source, sink, transform]", converter=SeaTunnelPluginTypeConverter.class)
    private PluginType pluginType;

    @Override
    public Command<?> buildCommand() {
        return new ConnectorCheckCommand(this);
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ConnectorCheckCommandArgs)) {
            return false;
        }
        ConnectorCheckCommandArgs other = (ConnectorCheckCommandArgs)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.isListConnectors() != other.isListConnectors()) {
            return false;
        }
        String this$pluginIdentifier = this.getPluginIdentifier();
        String other$pluginIdentifier = other.getPluginIdentifier();
        if (this$pluginIdentifier == null ? other$pluginIdentifier != null : !this$pluginIdentifier.equals(other$pluginIdentifier)) {
            return false;
        }
        PluginType this$pluginType = this.getPluginType();
        PluginType other$pluginType = other.getPluginType();
        return !(this$pluginType == null ? other$pluginType != null : !((Object)((Object)this$pluginType)).equals((Object)other$pluginType));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ConnectorCheckCommandArgs;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.isListConnectors() ? 79 : 97);
        String $pluginIdentifier = this.getPluginIdentifier();
        result = result * 59 + ($pluginIdentifier == null ? 43 : $pluginIdentifier.hashCode());
        PluginType $pluginType = this.getPluginType();
        result = result * 59 + ($pluginType == null ? 43 : ((Object)((Object)$pluginType)).hashCode());
        return result;
    }

    public boolean isListConnectors() {
        return this.listConnectors;
    }

    public String getPluginIdentifier() {
        return this.pluginIdentifier;
    }

    public PluginType getPluginType() {
        return this.pluginType;
    }

    public void setListConnectors(boolean listConnectors) {
        this.listConnectors = listConnectors;
    }

    public void setPluginIdentifier(String pluginIdentifier) {
        this.pluginIdentifier = pluginIdentifier;
    }

    public void setPluginType(PluginType pluginType) {
        this.pluginType = pluginType;
    }

    @Override
    public String toString() {
        return "ConnectorCheckCommandArgs(listConnectors=" + this.isListConnectors() + ", pluginIdentifier=" + this.getPluginIdentifier() + ", pluginType=" + (Object)((Object)this.getPluginType()) + ")";
    }

    public static class SeaTunnelPluginTypeConverter
    implements IStringConverter<PluginType> {
        @Override
        public PluginType convert(String value) {
            try {
                return PluginType.valueOf(value.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("The plugin type of seaTunnel only support these options: [source, transform, sink]");
            }
        }
    }
}

