/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.core.starter.seatunnel.command;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.ImmutableTriple;
import org.apache.seatunnel.api.configuration.Option;
import org.apache.seatunnel.api.configuration.util.OptionRule;
import org.apache.seatunnel.common.constants.PluginType;
import org.apache.seatunnel.core.starter.command.Command;
import org.apache.seatunnel.core.starter.exception.CommandExecuteException;
import org.apache.seatunnel.core.starter.exception.ConfigCheckException;
import org.apache.seatunnel.core.starter.seatunnel.args.ConnectorCheckCommandArgs;
import org.apache.seatunnel.plugin.discovery.PluginDiscovery;
import org.apache.seatunnel.plugin.discovery.PluginIdentifier;
import org.apache.seatunnel.plugin.discovery.seatunnel.SeaTunnelSinkPluginDiscovery;
import org.apache.seatunnel.plugin.discovery.seatunnel.SeaTunnelSourcePluginDiscovery;
import org.apache.seatunnel.plugin.discovery.seatunnel.SeaTunnelTransformPluginDiscovery;

public class ConnectorCheckCommand
implements Command<ConnectorCheckCommandArgs> {
    private static final String OPTION_DESCRIPTION_FORMAT = ", Description: '%s'";
    private static final String REQUIRED_OPTION_FORMAT = "Required Options: \n %s";
    private static final String OPTIONAL_OPTION_FORMAT = "Optional Options: \n %s";
    private static final Map<PluginType, PluginDiscovery> DISCOVERY_MAP = new HashMap<PluginType, PluginDiscovery>();
    private ConnectorCheckCommandArgs connectorCheckCommandArgs;

    public ConnectorCheckCommand(ConnectorCheckCommandArgs connectorCheckCommandArgs) {
        this.connectorCheckCommandArgs = connectorCheckCommandArgs;
        DISCOVERY_MAP.put(PluginType.SOURCE, new SeaTunnelSourcePluginDiscovery());
        DISCOVERY_MAP.put(PluginType.SINK, new SeaTunnelSinkPluginDiscovery());
        DISCOVERY_MAP.put(PluginType.TRANSFORM, new SeaTunnelTransformPluginDiscovery());
    }

    @Override
    public void execute() throws CommandExecuteException, ConfigCheckException {
        PluginType pluginType = this.connectorCheckCommandArgs.getPluginType();
        if (this.connectorCheckCommandArgs.isListConnectors()) {
            if (Objects.isNull((Object)pluginType)) {
                DISCOVERY_MAP.entrySet().forEach(pluginTypePluginDiscoveryEntry -> this.printSupportedPlugins((PluginType)((Object)((Object)pluginTypePluginDiscoveryEntry.getKey())), ((PluginDiscovery)pluginTypePluginDiscoveryEntry.getValue()).getPlugins()));
            } else {
                this.printSupportedPlugins(pluginType, DISCOVERY_MAP.get((Object)pluginType).getPlugins());
            }
        }
        String pluginIdentifier = this.connectorCheckCommandArgs.getPluginIdentifier();
        if (StringUtils.isNoneBlank(pluginIdentifier)) {
            if (Objects.isNull((Object)pluginType)) {
                DISCOVERY_MAP.entrySet().forEach(pluginTypePluginDiscoveryEntry -> this.printOptionRulesByPluginTypeAndIdentifier((PluginDiscovery)pluginTypePluginDiscoveryEntry.getValue(), pluginIdentifier));
            } else {
                this.printOptionRulesByPluginTypeAndIdentifier(DISCOVERY_MAP.get((Object)pluginType), pluginIdentifier);
            }
        }
    }

    private void printOptionRulesByPluginTypeAndIdentifier(PluginDiscovery DISCOVERY_MAP, String pluginIdentifier) {
        ImmutableTriple<PluginIdentifier, List<Option<?>>, List<Option<?>>> triple = DISCOVERY_MAP.getOptionRules(pluginIdentifier);
        if (Objects.nonNull(triple.getLeft())) {
            this.printOptionRules(triple.getLeft(), triple.getMiddle(), triple.getRight());
        }
    }

    private void printSupportedPlugins(PluginType pluginType, LinkedHashMap<PluginIdentifier, OptionRule> plugins) {
        System.out.println("\n" + StringUtils.capitalize(pluginType.getType()));
        String supportedPlugins = plugins.keySet().stream().map(pluginIdentifier -> pluginIdentifier.getPluginName()).collect(Collectors.joining(" "));
        System.out.println(supportedPlugins + "\n");
    }

    private void printOptionRules(PluginIdentifier pluginIdentifier, List<Option<?>> requiredOptions, List<Option<?>> optionOptions) {
        System.out.println("\n" + pluginIdentifier.getPluginName() + " " + pluginIdentifier.getPluginType());
        System.out.println(String.format(REQUIRED_OPTION_FORMAT, ConnectorCheckCommand.getOptionRulesString(requiredOptions)));
        if (optionOptions.size() > 0) {
            System.out.println(String.format(OPTIONAL_OPTION_FORMAT, ConnectorCheckCommand.getOptionRulesString(optionOptions)));
        }
    }

    private static String getOptionRulesString(List<Option<?>> requiredOptions) {
        String requiredOptionsString = requiredOptions.stream().map(option -> String.format(option.toString() + OPTION_DESCRIPTION_FORMAT, option.getDescription()) + "\n").collect(Collectors.joining(" "));
        return requiredOptionsString;
    }
}

