/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.engine.checkpoint.storage.hdfs.common;

import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.seatunnel.engine.checkpoint.storage.exception.CheckpointStorageException;

public abstract class AbstractConfiguration {
    protected static final String HDFS_IMPL_KEY = "impl";
    protected static final String COMMON_DISABLE_CACHE = "%s.disable.cache";
    protected static final String DISABLE_CACHE_DEFAULT_VALUE = "TRUE";
    protected static final String DISABLE_CACHE_KEY = "disable.cache";

    void checkConfiguration(Map<String, String> config, String ... keys) {
        for (String key : keys) {
            if (config.containsKey(key) && null != config.get(key)) continue;
            throw new IllegalArgumentException(key + " is required");
        }
    }

    public abstract Configuration buildConfiguration(Map<String, String> var1) throws CheckpointStorageException;

    void setExtraConfiguration(Configuration hadoopConf, Map<String, String> config, String prefix) {
        config.forEach((k, v) -> {
            if (k.startsWith(prefix)) {
                hadoopConf.set(k, v);
            }
        });
    }
}

