/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.engine.checkpoint.storage.hdfs.common;

import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.seatunnel.engine.checkpoint.storage.hdfs.common.AbstractConfiguration;

public class LocalConfiguration
extends AbstractConfiguration {
    private static final String HDFS_LOCAL_IMPL = "org.apache.hadoop.fs.LocalFileSystem";
    private static final String HDFS_LOCAL_IMPL_KEY = "fs.file.impl";

    @Override
    public Configuration buildConfiguration(Map<String, String> config) {
        Configuration hadoopConf = new Configuration();
        hadoopConf.set(HDFS_LOCAL_IMPL_KEY, HDFS_LOCAL_IMPL);
        hadoopConf.set("fs.defaultFS", config.getOrDefault("fs.defaultFS", "file:///"));
        hadoopConf.setBoolean(String.format("%s.disable.cache", HDFS_LOCAL_IMPL_KEY), Boolean.parseBoolean(config.getOrDefault("disable.cache", "TRUE")));
        return hadoopConf;
    }
}

