/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.engine.client.job;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import java.util.concurrent.CompletableFuture;
import lombok.NonNull;
import org.apache.seatunnel.common.utils.ExceptionUtils;
import org.apache.seatunnel.common.utils.RetryUtils;
import org.apache.seatunnel.engine.client.SeaTunnelHazelcastClient;
import org.apache.seatunnel.engine.common.exception.SeaTunnelEngineException;
import org.apache.seatunnel.engine.common.utils.ExceptionUtil;
import org.apache.seatunnel.engine.common.utils.PassiveCompletableFuture;
import org.apache.seatunnel.engine.core.job.Job;
import org.apache.seatunnel.engine.core.job.JobImmutableInformation;
import org.apache.seatunnel.engine.core.job.JobResult;
import org.apache.seatunnel.engine.core.job.JobStatus;
import org.apache.seatunnel.engine.core.protocol.codec.SeaTunnelCancelJobCodec;
import org.apache.seatunnel.engine.core.protocol.codec.SeaTunnelGetJobStatusCodec;
import org.apache.seatunnel.engine.core.protocol.codec.SeaTunnelSubmitJobCodec;
import org.apache.seatunnel.engine.core.protocol.codec.SeaTunnelWaitForJobCompleteCodec;

public class ClientJobProxy
implements Job {
    private static final ILogger LOGGER = Logger.getLogger(ClientJobProxy.class);
    private final SeaTunnelHazelcastClient seaTunnelHazelcastClient;
    private final Long jobId;
    private JobResult jobResult;

    public ClientJobProxy(@NonNull SeaTunnelHazelcastClient seaTunnelHazelcastClient, @NonNull JobImmutableInformation jobImmutableInformation) {
        if (seaTunnelHazelcastClient == null) {
            throw new NullPointerException("seaTunnelHazelcastClient is marked non-null but is null");
        }
        if (jobImmutableInformation == null) {
            throw new NullPointerException("jobImmutableInformation is marked non-null but is null");
        }
        this.seaTunnelHazelcastClient = seaTunnelHazelcastClient;
        this.jobId = jobImmutableInformation.getJobId();
        this.submitJob(jobImmutableInformation);
    }

    public ClientJobProxy(@NonNull SeaTunnelHazelcastClient seaTunnelHazelcastClient, Long jobId) {
        if (seaTunnelHazelcastClient == null) {
            throw new NullPointerException("seaTunnelHazelcastClient is marked non-null but is null");
        }
        this.seaTunnelHazelcastClient = seaTunnelHazelcastClient;
        this.jobId = jobId;
    }

    @Override
    public long getJobId() {
        return this.jobId;
    }

    private void submitJob(JobImmutableInformation jobImmutableInformation) {
        LOGGER.info(String.format("Start submit job, job id: %s, with plugin jar %s", jobImmutableInformation.getJobId(), jobImmutableInformation.getPluginJarsUrls()));
        ClientMessage request = SeaTunnelSubmitJobCodec.encodeRequest(jobImmutableInformation.getJobId(), this.seaTunnelHazelcastClient.getSerializationService().toData(jobImmutableInformation), jobImmutableInformation.isStartWithSavePoint());
        PassiveCompletableFuture<Void> submitJobFuture = this.seaTunnelHazelcastClient.requestOnMasterAndGetCompletableFuture(request);
        submitJobFuture.join();
        LOGGER.info(String.format("Submit job finished, job id: %s, job name: %s", jobImmutableInformation.getJobId(), jobImmutableInformation.getJobName()));
    }

    @Override
    public JobResult waitForJobCompleteV2() {
        try {
            this.jobResult = RetryUtils.retryWithException(() -> {
                PassiveCompletableFuture<JobResult> jobFuture = this.doWaitForJobComplete();
                return (JobResult)jobFuture.get();
            }, new RetryUtils.RetryMaterial(100000, true, ExceptionUtil::isOperationNeedRetryException, 2000L));
            if (this.jobResult == null) {
                throw new SeaTunnelEngineException("failed to fetch job result");
            }
        }
        catch (Exception e) {
            LOGGER.severe(String.format("Job (%s) end with unknown state, and throw Exception: %s", this.jobId, ExceptionUtils.getMessage(e)));
            throw new RuntimeException(e);
        }
        LOGGER.info(String.format("Job (%s) end with state %s", new Object[]{this.jobId, this.jobResult.getStatus()}));
        return this.jobResult;
    }

    public JobResult getJobResultCache() {
        return this.jobResult;
    }

    @Override
    public PassiveCompletableFuture<JobResult> doWaitForJobComplete() {
        return new PassiveCompletableFuture<JobResult>((CompletableFuture<JobResult>)this.seaTunnelHazelcastClient.requestOnMasterAndGetCompletableFuture(SeaTunnelWaitForJobCompleteCodec.encodeRequest(this.jobId), SeaTunnelWaitForJobCompleteCodec::decodeResponse).thenApply(jobResult -> (JobResult)this.seaTunnelHazelcastClient.getSerializationService().toObject(jobResult)));
    }

    @Override
    public void cancelJob() {
        PassiveCompletableFuture<Void> cancelFuture = this.seaTunnelHazelcastClient.requestOnMasterAndGetCompletableFuture(SeaTunnelCancelJobCodec.encodeRequest(this.jobId));
        cancelFuture.join();
    }

    @Override
    public JobStatus getJobStatus() {
        int jobStatusOrdinal = (Integer)this.seaTunnelHazelcastClient.requestOnMasterAndDecodeResponse(SeaTunnelGetJobStatusCodec.encodeRequest(this.jobId), SeaTunnelGetJobStatusCodec::decodeResponse);
        return JobStatus.values()[jobStatusOrdinal];
    }
}

