/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.engine.server.task;

import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import java.util.concurrent.CompletableFuture;
import lombok.NonNull;
import org.apache.seatunnel.api.common.metrics.MetricsContext;
import org.apache.seatunnel.api.table.type.Record;
import org.apache.seatunnel.api.transform.Collector;
import org.apache.seatunnel.engine.core.dag.actions.SourceAction;
import org.apache.seatunnel.engine.server.dag.physical.config.SourceConfig;
import org.apache.seatunnel.engine.server.dag.physical.flow.Flow;
import org.apache.seatunnel.engine.server.execution.ProgressState;
import org.apache.seatunnel.engine.server.execution.TaskLocation;
import org.apache.seatunnel.engine.server.task.SeaTunnelTask;
import org.apache.seatunnel.engine.server.task.SeaTunnelTransformCollector;
import org.apache.seatunnel.engine.server.task.TaskRuntimeException;
import org.apache.seatunnel.engine.server.task.flow.OneOutputFlowLifeCycle;
import org.apache.seatunnel.engine.server.task.flow.SourceFlowLifeCycle;
import org.apache.seatunnel.engine.server.task.record.Barrier;

public class TransformSeaTunnelTask
extends SeaTunnelTask {
    private static final ILogger LOGGER = Logger.getLogger(TransformSeaTunnelTask.class);
    private Collector<Record<?>> collector;

    public TransformSeaTunnelTask(long jobID, TaskLocation taskID, int indexID, Flow executionFlow) {
        super(jobID, taskID, indexID, executionFlow);
    }

    @Override
    public void init() throws Exception {
        super.init();
        LOGGER.info("starting seatunnel transform task, index " + this.indexID);
        this.collector = new SeaTunnelTransformCollector(this.outputs);
        if (!(this.startFlowLifeCycle instanceof OneOutputFlowLifeCycle)) {
            throw new TaskRuntimeException("TransformSeaTunnelTask only support OneOutputFlowLifeCycle, but get " + this.startFlowLifeCycle.getClass().getName());
        }
    }

    @Override
    protected SourceFlowLifeCycle<?, ?> createSourceFlowLifeCycle(SourceAction<?, ?, ?> sourceAction, SourceConfig config, CompletableFuture<Void> completableFuture, MetricsContext metricsContext) {
        throw new UnsupportedOperationException("TransformSeaTunnelTask can't create SourceFlowLifeCycle");
    }

    @Override
    protected void collect() throws Exception {
        ((OneOutputFlowLifeCycle)this.startFlowLifeCycle).collect(this.collector);
    }

    @Override
    @NonNull
    public ProgressState call() throws Exception {
        this.stateProcess();
        return this.progress.toState();
    }

    @Override
    public void triggerBarrier(Barrier checkpointBarrier) throws Exception {
    }
}

