/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.engine.server.telemetry.metrics.entity;

import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicLong;

public class ThreadPoolStatus {
    private int activeCount;
    private int corePoolSize;
    private int maximumPoolSize;
    private int poolSize;
    private long completedTaskCount;
    private long taskCount;
    private long queueTaskCount;
    private long rejectionCount;

    public int getActiveCount() {
        return this.activeCount;
    }

    public int getCorePoolSize() {
        return this.corePoolSize;
    }

    public int getMaximumPoolSize() {
        return this.maximumPoolSize;
    }

    public int getPoolSize() {
        return this.poolSize;
    }

    public long getCompletedTaskCount() {
        return this.completedTaskCount;
    }

    public long getTaskCount() {
        return this.taskCount;
    }

    public long getQueueTaskCount() {
        return this.queueTaskCount;
    }

    public long getRejectionCount() {
        return this.rejectionCount;
    }

    public void setActiveCount(int activeCount) {
        this.activeCount = activeCount;
    }

    public void setCorePoolSize(int corePoolSize) {
        this.corePoolSize = corePoolSize;
    }

    public void setMaximumPoolSize(int maximumPoolSize) {
        this.maximumPoolSize = maximumPoolSize;
    }

    public void setPoolSize(int poolSize) {
        this.poolSize = poolSize;
    }

    public void setCompletedTaskCount(long completedTaskCount) {
        this.completedTaskCount = completedTaskCount;
    }

    public void setTaskCount(long taskCount) {
        this.taskCount = taskCount;
    }

    public void setQueueTaskCount(long queueTaskCount) {
        this.queueTaskCount = queueTaskCount;
    }

    public void setRejectionCount(long rejectionCount) {
        this.rejectionCount = rejectionCount;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ThreadPoolStatus)) {
            return false;
        }
        ThreadPoolStatus other = (ThreadPoolStatus)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getActiveCount() != other.getActiveCount()) {
            return false;
        }
        if (this.getCorePoolSize() != other.getCorePoolSize()) {
            return false;
        }
        if (this.getMaximumPoolSize() != other.getMaximumPoolSize()) {
            return false;
        }
        if (this.getPoolSize() != other.getPoolSize()) {
            return false;
        }
        if (this.getCompletedTaskCount() != other.getCompletedTaskCount()) {
            return false;
        }
        if (this.getTaskCount() != other.getTaskCount()) {
            return false;
        }
        if (this.getQueueTaskCount() != other.getQueueTaskCount()) {
            return false;
        }
        return this.getRejectionCount() == other.getRejectionCount();
    }

    protected boolean canEqual(Object other) {
        return other instanceof ThreadPoolStatus;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getActiveCount();
        result = result * 59 + this.getCorePoolSize();
        result = result * 59 + this.getMaximumPoolSize();
        result = result * 59 + this.getPoolSize();
        long $completedTaskCount = this.getCompletedTaskCount();
        result = result * 59 + (int)($completedTaskCount >>> 32 ^ $completedTaskCount);
        long $taskCount = this.getTaskCount();
        result = result * 59 + (int)($taskCount >>> 32 ^ $taskCount);
        long $queueTaskCount = this.getQueueTaskCount();
        result = result * 59 + (int)($queueTaskCount >>> 32 ^ $queueTaskCount);
        long $rejectionCount = this.getRejectionCount();
        result = result * 59 + (int)($rejectionCount >>> 32 ^ $rejectionCount);
        return result;
    }

    public String toString() {
        return "ThreadPoolStatus(activeCount=" + this.getActiveCount() + ", corePoolSize=" + this.getCorePoolSize() + ", maximumPoolSize=" + this.getMaximumPoolSize() + ", poolSize=" + this.getPoolSize() + ", completedTaskCount=" + this.getCompletedTaskCount() + ", taskCount=" + this.getTaskCount() + ", queueTaskCount=" + this.getQueueTaskCount() + ", rejectionCount=" + this.getRejectionCount() + ")";
    }

    public ThreadPoolStatus(int activeCount, int corePoolSize, int maximumPoolSize, int poolSize, long completedTaskCount, long taskCount, long queueTaskCount, long rejectionCount) {
        this.activeCount = activeCount;
        this.corePoolSize = corePoolSize;
        this.maximumPoolSize = maximumPoolSize;
        this.poolSize = poolSize;
        this.completedTaskCount = completedTaskCount;
        this.taskCount = taskCount;
        this.queueTaskCount = queueTaskCount;
        this.rejectionCount = rejectionCount;
    }

    public static class RejectionCountingHandler
    extends ThreadPoolExecutor.AbortPolicy {
        private final AtomicLong rejectionCount = new AtomicLong(0L);

        @Override
        public void rejectedExecution(Runnable r, ThreadPoolExecutor executor) {
            this.rejectionCount.incrementAndGet();
            super.rejectedExecution(r, executor);
        }

        public long getRejectionCount() {
            return this.rejectionCount.get();
        }
    }
}

