/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.transform.nlpmodel;

import org.apache.commons.lang3.StringUtils;

public enum ModelProvider {
    OPENAI("https://api.openai.com/v1/chat/completions", "https://api.openai.com/v1/embeddings"),
    DOUBAO("https://ark.cn-beijing.volces.com/api/v3/chat/completions", "https://ark.cn-beijing.volces.com/api/v3/embeddings"),
    QIANFAN("", "https://aip.baidubce.com/rpc/2.0/ai_custom/v1/wenxinworkshop/embeddings"),
    KIMIAI("https://api.moonshot.cn/v1/chat/completions", ""),
    MICROSOFT("", ""),
    CUSTOM("", ""),
    LOCAL("", "");

    private final String LLMProviderPath;
    private final String EmbeddingProviderPath;

    private ModelProvider(String llmProviderPath, String embeddingProviderPath) {
        this.LLMProviderPath = llmProviderPath;
        this.EmbeddingProviderPath = embeddingProviderPath;
    }

    public String usedLLMPath(String path) {
        if (StringUtils.isBlank((CharSequence)path)) {
            return this.LLMProviderPath;
        }
        return path;
    }

    public String usedEmbeddingPath(String path) {
        if (StringUtils.isBlank((CharSequence)path)) {
            return this.EmbeddingProviderPath;
        }
        return path;
    }
}

