/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.app.controller;

import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.IOException;
import java.util.List;
import javax.annotation.Resource;
import org.apache.seatunnel.app.common.Result;
import org.apache.seatunnel.app.domain.response.metrics.JobDAG;
import org.apache.seatunnel.app.domain.response.metrics.JobPipelineDetailMetricsRes;
import org.apache.seatunnel.app.domain.response.metrics.JobPipelineSummaryMetricsRes;
import org.apache.seatunnel.app.service.IJobMetricsService;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RequestMapping(value={"/seatunnel/api/v1/job/metrics"})
@RestController
public class JobMetricsController {
    @Resource
    private IJobMetricsService jobMetricsService;

    @GetMapping(value={"/detail"})
    @ApiOperation(value="get the job pipeline detail metrics", httpMethod="GET")
    public Result<List<JobPipelineDetailMetricsRes>> detail(@ApiParam(value="userId", required=true) @RequestAttribute Integer userId, @ApiParam(value="jobInstanceId", required=true) @RequestParam Long jobInstanceId) throws IOException {
        return Result.success(this.jobMetricsService.getJobPipelineDetailMetricsRes(userId, jobInstanceId));
    }

    @GetMapping(value={"/dag"})
    @ApiOperation(value="get the job pipeline dag", httpMethod="GET")
    public Result<JobDAG> getJobDAG(@ApiParam(value="userId", required=true) @RequestAttribute Integer userId, @ApiParam(value="jobInstanceId", required=true) @RequestParam Long jobInstanceId) throws JsonProcessingException {
        return Result.success(this.jobMetricsService.getJobDAG(userId, jobInstanceId));
    }

    @GetMapping(value={"/summary"})
    @ApiOperation(value="get the job pipeline summary metrics", httpMethod="GET")
    public Result<List<JobPipelineSummaryMetricsRes>> summary(@ApiParam(value="userId", required=true) @RequestAttribute Integer userId, @ApiParam(value="jobInstanceId", required=true) @RequestParam Long jobInstanceId) throws IOException {
        return Result.success(this.jobMetricsService.getJobPipelineSummaryMetrics(userId, jobInstanceId));
    }
}

