/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.app.service.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import lombok.NonNull;
import org.apache.seatunnel.api.configuration.util.OptionRule;
import org.apache.seatunnel.app.bean.connector.ConnectorCache;
import org.apache.seatunnel.app.config.ConnectorDataSourceMapperConfig;
import org.apache.seatunnel.app.domain.request.connector.BusinessMode;
import org.apache.seatunnel.app.domain.request.connector.ConnectorStatus;
import org.apache.seatunnel.app.domain.request.connector.SceneMode;
import org.apache.seatunnel.app.domain.request.job.transform.Transform;
import org.apache.seatunnel.app.domain.response.connector.ConnectorInfo;
import org.apache.seatunnel.app.domain.response.connector.DataSourceInfo;
import org.apache.seatunnel.app.domain.response.connector.DataSourceInstance;
import org.apache.seatunnel.app.dynamicforms.FormStructure;
import org.apache.seatunnel.app.service.IConnectorService;
import org.apache.seatunnel.app.service.IDatasourceService;
import org.apache.seatunnel.app.service.IJobDefinitionService;
import org.apache.seatunnel.app.service.impl.SeatunnelBaseServiceImpl;
import org.apache.seatunnel.app.thirdparty.datasource.DataSourceConfigSwitcherUtils;
import org.apache.seatunnel.app.thirdparty.transfrom.TransformConfigSwitcherUtils;
import org.apache.seatunnel.common.constants.PluginType;
import org.apache.seatunnel.server.common.SeatunnelErrorEnum;
import org.apache.seatunnel.server.common.SeatunnelException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ConnectorServiceImpl
extends SeatunnelBaseServiceImpl
implements IConnectorService {
    private final ConnectorCache connectorCache;
    @Autowired
    private ConnectorDataSourceMapperConfig dataSourceMapperConfig;
    @Resource
    private IDatasourceService datasourceService;
    @Resource
    private IJobDefinitionService jobDefinitionService;
    private static final List<String> SKIP_SOURCE = Collections.emptyList();
    private static final List<String> SKIP_SINK = Collections.singletonList("Console");

    @Autowired
    public ConnectorServiceImpl(ConnectorCache connectorCache) {
        this.connectorCache = connectorCache;
    }

    @Override
    public List<ConnectorInfo> listSources(ConnectorStatus status) {
        this.funcPermissionCheck("project:seatunnel-task:sources", 0);
        List<ConnectorInfo> connectorInfos = status == ConnectorStatus.ALL ? this.connectorCache.getAllConnectors(PluginType.SOURCE) : (status == ConnectorStatus.DOWNLOADED ? this.connectorCache.getDownLoadConnector(PluginType.SOURCE) : this.connectorCache.getNotDownLoadConnector(PluginType.SOURCE));
        return connectorInfos.stream().filter(c -> !SKIP_SOURCE.contains(c.getPluginIdentifier().getPluginName())).collect(Collectors.toList());
    }

    @Override
    public List<DataSourceInstance> listSourceDataSourceInstances(Long jobId, SceneMode sceneMode, ConnectorStatus status) {
        this.funcPermissionCheck("project:seatunnel-task:datasource-sources", 0);
        BusinessMode businessMode = BusinessMode.valueOf(this.jobDefinitionService.getJobDefinitionByJobId(jobId).getJobType().toUpperCase());
        return this.filterImplementDataSource(this.listSources(status), businessMode, sceneMode, PluginType.SOURCE).stream().flatMap(dataSourceInfo -> this.getDataSourcesInstance((DataSourceInfo)dataSourceInfo).stream()).collect(Collectors.toList());
    }

    @Override
    public List<ConnectorInfo> listTransforms() {
        this.funcPermissionCheck("project:seatunnel-task:transforms", 0);
        return this.connectorCache.getTransform();
    }

    @Override
    public List<ConnectorInfo> listTransformsForJob(Long jobId) {
        this.funcPermissionCheck("project:seatunnel-task:datasource-transforms", 0);
        BusinessMode businessMode = BusinessMode.valueOf(this.jobDefinitionService.getJobDefinitionByJobId(jobId).getJobType().toUpperCase());
        if (businessMode.equals((Object)BusinessMode.DATA_INTEGRATION)) {
            return this.connectorCache.getTransform().stream().filter(connectorInfo -> {
                String pluginName = connectorInfo.getPluginIdentifier().getPluginName();
                return pluginName.equals("FieldMapper") || pluginName.equals("FilterRowKind") || pluginName.equals("Replace") || pluginName.equals("Copy") || pluginName.equals("MultiFieldSplit") || pluginName.equals("Sql");
            }).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    @Override
    public List<ConnectorInfo> listSinks(ConnectorStatus status) {
        this.funcPermissionCheck("project:seatunnel-task:sinks", 0);
        List<ConnectorInfo> connectorInfos = status == ConnectorStatus.ALL ? this.connectorCache.getAllConnectors(PluginType.SINK) : (status == ConnectorStatus.DOWNLOADED ? this.connectorCache.getDownLoadConnector(PluginType.SINK) : this.connectorCache.getNotDownLoadConnector(PluginType.SINK));
        return connectorInfos.stream().filter(c -> !SKIP_SINK.contains(c.getPluginIdentifier().getPluginName())).collect(Collectors.toList());
    }

    @Override
    public List<DataSourceInstance> listSinkDataSourcesInstances(Long jobId, ConnectorStatus status) {
        this.funcPermissionCheck("project:seatunnel-task:datasource-sinks", 0);
        BusinessMode businessMode = BusinessMode.valueOf(this.jobDefinitionService.getJobDefinitionByJobId(jobId).getJobType().toUpperCase());
        return this.filterImplementDataSource(this.listSinks(status), businessMode, null, PluginType.SINK).stream().flatMap(dataSourceInfo -> this.getDataSourcesInstance((DataSourceInfo)dataSourceInfo).stream()).collect(Collectors.toList());
    }

    @Override
    public void sync() throws IOException {
        this.funcPermissionCheck("project:seatunnel-task:sync", 0);
        this.connectorCache.refresh();
    }

    @Override
    public FormStructure getConnectorFormStructure(@NonNull String pluginType, @NonNull String connectorName) {
        if (pluginType == null) {
            throw new NullPointerException("pluginType is marked non-null but is null");
        }
        if (connectorName == null) {
            throw new NullPointerException("connectorName is marked non-null but is null");
        }
        this.funcPermissionCheck("project:seatunnel-task:form", 0);
        FormStructure formStructure = this.connectorCache.getFormStructure(pluginType, connectorName);
        if (formStructure == null) {
            throw new SeatunnelException(SeatunnelErrorEnum.CONNECTOR_NOT_FOUND, new Object[]{pluginType, connectorName});
        }
        return formStructure;
    }

    @Override
    public FormStructure getTransformFormStructure(@NonNull String pluginType, @NonNull String connectorName) {
        if (pluginType == null) {
            throw new NullPointerException("pluginType is marked non-null but is null");
        }
        if (connectorName == null) {
            throw new NullPointerException("connectorName is marked non-null but is null");
        }
        OptionRule optionRule = this.connectorCache.getOptionRule(pluginType, connectorName);
        return TransformConfigSwitcherUtils.getFormStructure(Transform.valueOf(connectorName.toUpperCase()), optionRule);
    }

    @Override
    public FormStructure getDatasourceFormStructure(@NonNull Long jobId, @NonNull Long dataSourceInstanceId, @NonNull String pluginType) {
        if (jobId == null) {
            throw new NullPointerException("jobId is marked non-null but is null");
        }
        if (dataSourceInstanceId == null) {
            throw new NullPointerException("dataSourceInstanceId is marked non-null but is null");
        }
        if (pluginType == null) {
            throw new NullPointerException("pluginType is marked non-null but is null");
        }
        this.funcPermissionCheck("project:seatunnel-task:datasource-form", 0);
        BusinessMode businessMode = BusinessMode.valueOf(this.jobDefinitionService.getJobDefinitionByJobId(jobId).getJobType().toUpperCase());
        String dataSourceName = this.datasourceService.queryDatasourceDetailById(dataSourceInstanceId.toString()).getPluginName();
        OptionRule dataSourceNameOptionRole = this.datasourceService.queryOptionRuleByPluginName(dataSourceName);
        OptionRule virtualTableOptionRule = this.datasourceService.queryVirtualTableOptionRuleByPluginName(dataSourceName);
        String connectorName = this.dataSourceMapperConfig.findConnectorForDatasourceName(dataSourceName).get();
        PluginType connectorPluginType = PluginType.valueOf((String)pluginType.toUpperCase(Locale.ROOT));
        return DataSourceConfigSwitcherUtils.filterOptionRule(dataSourceName, connectorName, dataSourceNameOptionRole, virtualTableOptionRule, connectorPluginType, businessMode, this.connectorCache.getOptionRule(pluginType, connectorName));
    }

    private List<DataSourceInfo> filterImplementDataSource(List<ConnectorInfo> connectorInfoS, BusinessMode businessMode, SceneMode sceneMode, PluginType pluginType) {
        ArrayList<DataSourceInfo> dataSourceList = new ArrayList<DataSourceInfo>();
        connectorInfoS.forEach(connectorInfo -> {
            String connectorName = connectorInfo.getPluginIdentifier().getPluginName();
            ConnectorDataSourceMapperConfig.ConnectorMapper connectorMapper = this.dataSourceMapperConfig.getConnectorDatasourceMappers().get(connectorName);
            if (null != connectorMapper) {
                connectorMapper.getDataSources().forEach(datasourceName -> {
                    Optional<List<SceneMode>> sceneModes = this.dataSourceMapperConfig.supportedSceneMode((String)datasourceName, pluginType);
                    Optional<List<BusinessMode>> businessModes = this.dataSourceMapperConfig.supportedBusinessMode((String)datasourceName, pluginType);
                    if ((businessMode == null || businessModes.isPresent() && businessModes.get().contains((Object)businessMode)) && (sceneMode == null || sceneModes.isPresent() && sceneModes.get().contains((Object)sceneMode))) {
                        dataSourceList.add(new DataSourceInfo((ConnectorInfo)connectorInfo, (String)datasourceName));
                    }
                });
            }
        });
        return dataSourceList;
    }

    private List<DataSourceInstance> getDataSourcesInstance(DataSourceInfo dataSourceInfo) {
        return this.datasourceService.queryDatasourceNameByPluginName(dataSourceInfo.getDatasourceName()).entrySet().stream().map(en -> new DataSourceInstance(dataSourceInfo, (String)en.getValue(), Long.parseLong((String)en.getKey()))).collect(Collectors.toList());
    }
}

