/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.engine.core.job;

public enum JobStatus {
    INITIALIZING(EndState.NOT_END),
    CREATED(EndState.NOT_END),
    SCHEDULED(EndState.NOT_END),
    RUNNING(EndState.NOT_END),
    FAILING(EndState.NOT_END),
    FAILED(EndState.GLOBALLY),
    CANCELLING(EndState.NOT_END),
    CANCELED(EndState.GLOBALLY),
    FINISHED(EndState.GLOBALLY),
    RESTARTING(EndState.NOT_END),
    SUSPENDED(EndState.LOCALLY),
    RECONCILING(EndState.NOT_END);

    private final EndState endState;

    private JobStatus(EndState endState) {
        this.endState = endState;
    }

    public boolean isGloballyEndState() {
        return this.endState == EndState.GLOBALLY;
    }

    public boolean isEndState() {
        return this.endState != EndState.NOT_END;
    }

    private static enum EndState {
        NOT_END,
        LOCALLY,
        GLOBALLY;

    }
}

