/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sedona.core.joinJudgement;

import java.io.Serializable;
import java.util.Collections;
import java.util.Iterator;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.sedona.core.enums.IndexType;
import org.apache.sedona.core.enums.JoinBuildSide;
import org.apache.sedona.core.joinJudgement.JudgementBase;
import org.apache.sedona.core.monitoring.Metric;
import org.apache.sedona.core.spatialOperator.SpatialPredicate;
import org.apache.sedona.core.utils.TimeUtils;
import org.apache.spark.api.java.function.FlatMapFunction2;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.index.SpatialIndex;
import org.locationtech.jts.index.quadtree.Quadtree;
import org.locationtech.jts.index.strtree.STRtree;

public class DynamicIndexLookupJudgement<T extends Geometry, U extends Geometry>
extends JudgementBase<T, U>
implements FlatMapFunction2<Iterator<U>, Iterator<T>, Pair<U, T>>,
Serializable {
    private final IndexType indexType;
    private final JoinBuildSide joinBuildSide;

    public DynamicIndexLookupJudgement(SpatialPredicate spatialPredicate, IndexType indexType, JoinBuildSide joinBuildSide, Metric buildCount, Metric streamCount, Metric resultCount, Metric candidateCount) {
        super(spatialPredicate, buildCount, streamCount, resultCount, candidateCount);
        this.indexType = indexType;
        this.joinBuildSide = joinBuildSide;
    }

    public Iterator<Pair<U, T>> call(Iterator<U> leftShapes, Iterator<T> rightShapes) throws Exception {
        Iterator<Object> streamShapes;
        Iterator<Object> buildShapes;
        boolean buildLeft;
        if (!leftShapes.hasNext() || !rightShapes.hasNext()) {
            this.buildCount.add(0L);
            this.streamCount.add(0L);
            this.resultCount.add(0L);
            this.candidateCount.add(0L);
            return Collections.emptyIterator();
        }
        this.initPartition();
        boolean bl = buildLeft = this.joinBuildSide == JoinBuildSide.LEFT;
        if (buildLeft) {
            buildShapes = leftShapes;
            streamShapes = rightShapes;
        } else {
            buildShapes = rightShapes;
            streamShapes = leftShapes;
        }
        final SpatialIndex spatialIndex = this.buildIndex(buildShapes);
        return new Iterator<Pair<U, T>>(){

            @Override
            public boolean hasNext() {
                return DynamicIndexLookupJudgement.this.hasNextBase(spatialIndex, streamShapes, buildLeft);
            }

            @Override
            public Pair<U, T> next() {
                return DynamicIndexLookupJudgement.this.nextBase(spatialIndex, streamShapes, buildLeft);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    private SpatialIndex buildIndex(Iterator<? extends Geometry> geometries) {
        long startTime = System.currentTimeMillis();
        long count = 0L;
        SpatialIndex index = this.newIndex();
        while (geometries.hasNext()) {
            Geometry geometry = geometries.next();
            index.insert(geometry.getEnvelopeInternal(), geometry);
            ++count;
        }
        index.query(new Envelope(0.0, 0.0, 0.0, 0.0));
        this.log("Loaded %d shapes into an index in %d ms", count, TimeUtils.elapsedSince(startTime));
        this.buildCount.add((int)count);
        return index;
    }

    private SpatialIndex newIndex() {
        switch (this.indexType) {
            case RTREE: {
                return new STRtree();
            }
            case QUADTREE: {
                return new Quadtree();
            }
        }
        throw new IllegalArgumentException("Unsupported index type: " + this.indexType);
    }
}

