/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sedona.common.raster;

import java.awt.image.Raster;
import java.util.Arrays;
import org.apache.sedona.common.raster.RasterAccessors;
import org.apache.sedona.common.raster.RasterBandAccessors;
import org.apache.sedona.common.utils.RasterUtils;
import org.geotools.coverage.GridSampleDimension;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridEnvelope2D;
import org.geotools.coverage.grid.GridGeometry2D;
import org.geotools.referencing.operation.transform.AffineTransform2D;
import org.opengis.coverage.grid.GridEnvelope;
import org.opengis.metadata.spatial.PixelOrientation;
import org.opengis.referencing.operation.MathTransform;

public class RasterBandEditors {
    public static GridCoverage2D setBandNoDataValue(GridCoverage2D raster, int bandIndex, double noDataValue) {
        RasterUtils.ensureBand(raster, bandIndex);
        Double rasterNoData = RasterBandAccessors.getBandNoDataValue(raster, bandIndex);
        if (rasterNoData != null && rasterNoData == noDataValue) {
            return raster;
        }
        GridSampleDimension[] bands = raster.getSampleDimensions();
        bands[bandIndex - 1] = RasterUtils.createSampleDimensionWithNoDataValue(bands[bandIndex - 1], noDataValue);
        int width = RasterAccessors.getWidth(raster);
        int height = RasterAccessors.getHeight(raster);
        AffineTransform2D affine = RasterUtils.getGDALAffineTransform(raster);
        GridGeometry2D gridGeometry2D = new GridGeometry2D((GridEnvelope)new GridEnvelope2D(0, 0, width, height), PixelOrientation.UPPER_LEFT, (MathTransform)affine, raster.getCoordinateReferenceSystem2D(), null);
        return RasterUtils.create(raster.getRenderedImage(), gridGeometry2D, bands, null);
    }

    public static GridCoverage2D setBandNoDataValue(GridCoverage2D raster, double noDataValue) {
        return RasterBandEditors.setBandNoDataValue(raster, 1, noDataValue);
    }

    public static GridCoverage2D addBand(GridCoverage2D toRaster, GridCoverage2D fromRaster, int fromBand, int toRasterIndex) {
        RasterUtils.ensureBand(fromRaster, fromBand);
        RasterBandEditors.ensureBandAppend(toRaster, toRasterIndex);
        RasterBandEditors.isRasterSameShape(toRaster, fromRaster);
        int width = RasterAccessors.getWidth(toRaster);
        int height = RasterAccessors.getHeight(toRaster);
        Raster rasterData = RasterUtils.getRaster(fromRaster.getRenderedImage());
        int dataTypeCode = RasterUtils.getRaster(toRaster.getRenderedImage()).getDataBuffer().getDataType();
        int numBands = RasterAccessors.numBands(toRaster);
        Double noDataValue = RasterBandAccessors.getBandNoDataValue(fromRaster, fromBand);
        if (RasterUtils.isDataTypeIntegral(dataTypeCode)) {
            int[] bandValues = rasterData.getSamples(0, 0, width, height, fromBand - 1, (int[])null);
            if (numBands + 1 == toRasterIndex) {
                return RasterUtils.copyRasterAndAppendBand(toRaster, (Number[])Arrays.stream(bandValues).boxed().toArray(Integer[]::new), noDataValue);
            }
            return RasterUtils.copyRasterAndReplaceBand(toRaster, fromBand, (Number[])Arrays.stream(bandValues).boxed().toArray(Integer[]::new), noDataValue, false);
        }
        double[] bandValues = rasterData.getSamples(0, 0, width, height, fromBand - 1, (double[])null);
        if (numBands + 1 == toRasterIndex) {
            return RasterUtils.copyRasterAndAppendBand(toRaster, (Number[])Arrays.stream(bandValues).boxed().toArray(Double[]::new), noDataValue);
        }
        return RasterUtils.copyRasterAndReplaceBand(toRaster, fromBand, (Number[])Arrays.stream(bandValues).boxed().toArray(Double[]::new), noDataValue, false);
    }

    public static GridCoverage2D addBand(GridCoverage2D toRaster, GridCoverage2D fromRaster, int fromBand) {
        int endBand = RasterAccessors.numBands(toRaster) + 1;
        return RasterBandEditors.addBand(toRaster, fromRaster, fromBand, endBand);
    }

    public static GridCoverage2D addBand(GridCoverage2D toRaster, GridCoverage2D fromRaster) {
        return RasterBandEditors.addBand(toRaster, fromRaster, 1);
    }

    private static void ensureBandAppend(GridCoverage2D raster, int band) {
        if (band < 1 || band > RasterAccessors.numBands(raster) + 1) {
            throw new IllegalArgumentException(String.format("Provided band index %d is not present in the raster", band));
        }
    }

    private static void isRasterSameShape(GridCoverage2D raster1, GridCoverage2D raster2) {
        int width1 = RasterAccessors.getWidth(raster1);
        int height1 = RasterAccessors.getHeight(raster1);
        int width2 = RasterAccessors.getWidth(raster2);
        int height2 = RasterAccessors.getHeight(raster2);
        if (width1 != width2 && height1 != height2) {
            throw new IllegalArgumentException(String.format("Provided rasters are not of same shape. \nFirst raster having width of %d and height of %d. \nSecond raster having width of %d and height of %d", width1, height1, width2, height2));
        }
    }
}

