/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.jaiext.jiffle.parser.node;

import it.geosolutions.jaiext.jiffle.parser.node.Band;
import it.geosolutions.jaiext.jiffle.parser.node.Node;
import it.geosolutions.jaiext.jiffle.parser.node.Pixel;
import it.geosolutions.jaiext.jiffle.parser.node.SourceWriter;
import it.geosolutions.jaiext.jiffle.util.Strings;
import java.util.Objects;

public class ImagePos
implements Node {
    public static ImagePos DEFAULT = new ImagePos(Band.DEFAULT, Pixel.DEFAULT);
    private final Band band;
    private final Pixel pixel;

    public ImagePos(Band band, Pixel pixel) {
        this.band = band;
        this.pixel = pixel;
    }

    public String toString() {
        return Strings.commas(this.pixel, this.band);
    }

    @Override
    public void write(SourceWriter w) {
        if (this.pixel != null) {
            w.append(this.pixel);
            if (this.band != null) {
                w.append(", ");
            }
        }
        if (this.band != null) {
            w.append(this.band);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImagePos imagePos = (ImagePos)o;
        return Objects.equals(this.band, imagePos.band) && Objects.equals(this.pixel, imagePos.pixel);
    }

    public int hashCode() {
        return Objects.hash(this.band, this.pixel);
    }

    public Band getBand() {
        return this.band;
    }

    public Pixel getPixel() {
        return this.pixel;
    }
}

