/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.dataset.transform;

import ucar.nc2.AttributeContainer;
import ucar.nc2.dataset.ProjectionCT;
import ucar.nc2.dataset.transform.AbstractTransformBuilder;
import ucar.nc2.dataset.transform.HorizTransformBuilderIF;

public class Mercator
extends AbstractTransformBuilder
implements HorizTransformBuilderIF {
    @Override
    public String getTransformName() {
        return "mercator";
    }

    @Override
    public ProjectionCT makeCoordinateTransform(AttributeContainer ctv, String geoCoordinateUnits) {
        double par = this.readAttributeDouble(ctv, "standard_parallel", Double.NaN);
        if (Double.isNaN(par)) {
            double scale = this.readAttributeDouble(ctv, "scale_factor_at_projection_origin", Double.NaN);
            if (Double.isNaN(scale)) {
                throw new IllegalArgumentException("Mercator projection must have attribute standard_parallel or scale_factor_at_projection_origin");
            }
            par = ucar.unidata.geoloc.projection.Mercator.convertScaleToStandardParallel(scale);
        }
        this.readStandardParams(ctv, geoCoordinateUnits);
        ucar.unidata.geoloc.projection.Mercator proj = new ucar.unidata.geoloc.projection.Mercator(this.lon0, par, this.false_easting, this.false_northing, this.earth_radius);
        return new ProjectionCT(ctv.getName(), "FGDC", proj);
    }
}

