/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.operation.overlayng;

import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateFilter;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.PrecisionModel;
import org.locationtech.jts.io.OrdinateFormat;
import org.locationtech.jts.math.MathUtil;

public class PrecisionUtil {
    public static int MAX_ROBUST_DP_DIGITS = 14;

    public static PrecisionModel robustPM(Geometry a, Geometry b) {
        double scale = PrecisionUtil.robustScale(a, b);
        return new PrecisionModel(scale);
    }

    public static double safeScale(double value) {
        return PrecisionUtil.precisionScale(value, MAX_ROBUST_DP_DIGITS);
    }

    public static double safeScale(Geometry geom) {
        return PrecisionUtil.safeScale(PrecisionUtil.maxBoundMagnitude(geom.getEnvelopeInternal()));
    }

    public static double safeScale(Geometry a, Geometry b) {
        double maxBnd = PrecisionUtil.maxBoundMagnitude(a.getEnvelopeInternal());
        if (b != null) {
            double maxBndB = PrecisionUtil.maxBoundMagnitude(b.getEnvelopeInternal());
            maxBnd = Math.max(maxBnd, maxBndB);
        }
        double scale = PrecisionUtil.safeScale(maxBnd);
        return scale;
    }

    private static double maxBoundMagnitude(Envelope env) {
        return MathUtil.max(Math.abs(env.getMaxX()), Math.abs(env.getMaxY()), Math.abs(env.getMinX()), Math.abs(env.getMinY()));
    }

    private static double precisionScale(double value, int precisionDigits) {
        int magnitude = (int)(Math.log(value) / Math.log(10.0) + 1.0);
        int precDigits = precisionDigits - magnitude;
        double scaleFactor = Math.pow(10.0, precDigits);
        return scaleFactor;
    }

    public static double inherentScale(double value) {
        int numDec = PrecisionUtil.numberOfDecimals(value);
        double scaleFactor = Math.pow(10.0, numDec);
        return scaleFactor;
    }

    public static double inherentScale(Geometry geom) {
        InherentScaleFilter scaleFilter = new InherentScaleFilter();
        geom.apply(scaleFilter);
        return scaleFilter.getScale();
    }

    public static double inherentScale(Geometry a, Geometry b) {
        double scale = PrecisionUtil.inherentScale(a);
        if (b != null) {
            double scaleB = PrecisionUtil.inherentScale(b);
            scale = Math.max(scale, scaleB);
        }
        return scale;
    }

    private static int numberOfDecimals(double value) {
        String s2 = OrdinateFormat.DEFAULT.format(value);
        if (s2.endsWith(".0")) {
            return 0;
        }
        int len = s2.length();
        int decIndex = s2.indexOf(46);
        if (decIndex <= 0) {
            return 0;
        }
        return len - decIndex - 1;
    }

    public static PrecisionModel robustPM(Geometry a) {
        double scale = PrecisionUtil.robustScale(a);
        return new PrecisionModel(scale);
    }

    public static double robustScale(Geometry a, Geometry b) {
        double inherentScale = PrecisionUtil.inherentScale(a, b);
        double safeScale = PrecisionUtil.safeScale(a, b);
        return PrecisionUtil.robustScale(inherentScale, safeScale);
    }

    public static double robustScale(Geometry a) {
        double inherentScale = PrecisionUtil.inherentScale(a);
        double safeScale = PrecisionUtil.safeScale(a);
        return PrecisionUtil.robustScale(inherentScale, safeScale);
    }

    private static double robustScale(double inherentScale, double safeScale) {
        if (inherentScale <= safeScale) {
            return inherentScale;
        }
        return safeScale;
    }

    private static class InherentScaleFilter
    implements CoordinateFilter {
        private double scale = 0.0;

        private InherentScaleFilter() {
        }

        public double getScale() {
            return this.scale;
        }

        @Override
        public void filter(Coordinate coord) {
            this.updateScaleMax(coord.getX());
            this.updateScaleMax(coord.getY());
        }

        private void updateScaleMax(double value) {
            double scaleVal = PrecisionUtil.inherentScale(value);
            if (scaleVal > this.scale) {
                this.scale = scaleVal;
            }
        }
    }
}

