/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sedona.core.showcase;

import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.sedona.common.enums.FileDataSplitter;
import org.apache.sedona.core.enums.IndexType;
import org.apache.sedona.core.formatMapper.EarthdataHDFPointMapper;
import org.apache.sedona.core.showcase.ScalaEarthdataMapperRunnableExample$delayedInit$body;
import org.apache.sedona.core.spatialOperator.RangeQuery;
import org.apache.sedona.core.spatialOperator.SpatialPredicate;
import org.apache.sedona.core.spatialRDD.PointRDD;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.api.java.JavaSparkContext$;
import org.locationtech.jts.geom.Envelope;
import scala.App;
import scala.Function0;
import scala.Predef$;
import scala.collection.mutable.ListBuffer;
import scala.runtime.BoxedUnit;
import scala.runtime.Statics;

public final class ScalaEarthdataMapperRunnableExample$
implements App {
    public static final ScalaEarthdataMapperRunnableExample$ MODULE$ = new ScalaEarthdataMapperRunnableExample$();
    private static SparkConf conf;
    private static SparkContext sc;
    private static String InputLocation;
    private static FileDataSplitter splitter;
    private static IndexType indexType;
    private static Envelope queryEnvelope;
    private static int numPartitions;
    private static int loopTimes;
    private static int HDFIncrement;
    private static int HDFOffset;
    private static String HDFRootGroupName;
    private static String HDFDataVariableName;
    private static String urlPrefix;
    private static String[] HDFDataVariableList;
    private static long executionStart;
    private static String[] scala$App$$_args;
    private static ListBuffer<Function0<BoxedUnit>> scala$App$$initCode;

    static {
        App.$init$((App)MODULE$);
        MODULE$.delayedInit((Function0<BoxedUnit>)new ScalaEarthdataMapperRunnableExample$delayedInit$body(MODULE$));
        Statics.releaseFence();
    }

    public final String[] args() {
        return App.args$((App)this);
    }

    public void delayedInit(Function0<BoxedUnit> body2) {
        App.delayedInit$((App)this, body2);
    }

    public final void main(String[] args) {
        App.main$((App)this, (String[])args);
    }

    public final long executionStart() {
        return executionStart;
    }

    public String[] scala$App$$_args() {
        return scala$App$$_args;
    }

    public void scala$App$$_args_$eq(String[] x$1) {
        scala$App$$_args = x$1;
    }

    public ListBuffer<Function0<BoxedUnit>> scala$App$$initCode() {
        return scala$App$$initCode;
    }

    public final void scala$App$_setter_$executionStart_$eq(long x$1) {
        executionStart = x$1;
    }

    public final void scala$App$_setter_$scala$App$$initCode_$eq(ListBuffer<Function0<BoxedUnit>> x$1) {
        scala$App$$initCode = x$1;
    }

    public SparkConf conf() {
        return conf;
    }

    public SparkContext sc() {
        return sc;
    }

    public String InputLocation() {
        return InputLocation;
    }

    public FileDataSplitter splitter() {
        return splitter;
    }

    public IndexType indexType() {
        return indexType;
    }

    public Envelope queryEnvelope() {
        return queryEnvelope;
    }

    public int numPartitions() {
        return numPartitions;
    }

    public int loopTimes() {
        return loopTimes;
    }

    public int HDFIncrement() {
        return HDFIncrement;
    }

    public int HDFOffset() {
        return HDFOffset;
    }

    public String HDFRootGroupName() {
        return HDFRootGroupName;
    }

    public String HDFDataVariableName() {
        return HDFDataVariableName;
    }

    public String urlPrefix() {
        return urlPrefix;
    }

    public String[] HDFDataVariableList() {
        return HDFDataVariableList;
    }

    public void testSpatialRangeQuery() {
        EarthdataHDFPointMapper earthdataHDFPoint = new EarthdataHDFPointMapper(this.HDFIncrement(), this.HDFOffset(), this.HDFRootGroupName(), this.HDFDataVariableList(), this.HDFDataVariableName(), this.urlPrefix());
        PointRDD spatialRDD = new PointRDD(JavaSparkContext$.MODULE$.fromSparkContext(this.sc()), this.InputLocation(), Predef$.MODULE$.int2Integer(this.numPartitions()), earthdataHDFPoint);
        for (int i = 0; i < this.loopTimes(); ++i) {
            long resultSize = 0L;
            resultSize = RangeQuery.SpatialRangeQuery(spatialRDD, this.queryEnvelope(), SpatialPredicate.COVERED_BY, false).count();
        }
    }

    public void testSpatialRangeQueryUsingIndex() {
        EarthdataHDFPointMapper earthdataHDFPoint = new EarthdataHDFPointMapper(this.HDFIncrement(), this.HDFOffset(), this.HDFRootGroupName(), this.HDFDataVariableList(), this.HDFDataVariableName(), this.urlPrefix());
        PointRDD spatialRDD = new PointRDD(JavaSparkContext$.MODULE$.fromSparkContext(this.sc()), this.InputLocation(), Predef$.MODULE$.int2Integer(this.numPartitions()), earthdataHDFPoint);
        spatialRDD.buildIndex(IndexType.RTREE, false);
        for (int i = 0; i < this.loopTimes(); ++i) {
            long resultSize = 0L;
            resultSize = RangeQuery.SpatialRangeQuery(spatialRDD, this.queryEnvelope(), SpatialPredicate.COVERED_BY, true).count();
        }
    }

    public final void delayedEndpoint$org$apache$sedona$core$showcase$ScalaEarthdataMapperRunnableExample$1() {
        conf = new SparkConf().setAppName("EarthdataMapperRunnableExample").setMaster("local[2]");
        sc = new SparkContext(this.conf());
        Logger.getLogger((String)"org").setLevel(Level.WARN);
        Logger.getLogger((String)"akka").setLevel(Level.WARN);
        InputLocation = new StringBuilder(35).append(System.getProperty("user.dir")).append("/src/test/resources/modis/modis.csv").toString();
        splitter = FileDataSplitter.CSV;
        indexType = IndexType.RTREE;
        queryEnvelope = new Envelope(-90.01, -80.01, 30.01, 40.01);
        numPartitions = 5;
        loopTimes = 1;
        HDFIncrement = 5;
        HDFOffset = 2;
        HDFRootGroupName = "MOD_Swath_LST";
        HDFDataVariableName = "LST";
        urlPrefix = new StringBuilder(26).append(System.getProperty("user.dir")).append("/src/test/resources/modis/").toString();
        HDFDataVariableList = (String[])((Object[])new String[]{"LST", "QC", "Error_LST", "Emis_31", "Emis_32"});
        this.testSpatialRangeQuery();
        this.testSpatialRangeQueryUsingIndex();
        this.sc().stop();
        System.out.println("All Earthdata DEMOs passed!");
    }

    private ScalaEarthdataMapperRunnableExample$() {
    }
}

