/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sedona.common.simplify;

import org.locationtech.jts.geom.Coordinate;

public class CoordinateSplitter {
    private static final double DBL_EPSILON = 2.220446049250313E-16;

    public static SplitInPlace splitInPlace(Coordinate[] geom, int itFirst, int itLast, double maxDistanceSquared) {
        Coordinate pointB;
        Coordinate pointA;
        int split = itFirst;
        double maxDistance = maxDistanceSquared;
        if (itFirst - itLast < 2) {
            new SplitInPlace(geom, itFirst);
        }
        if (CoordinateSplitter.calculateSquaredDistance(pointA = geom[itFirst], pointB = geom[itLast]) < 2.220446049250313E-16) {
            for (int itk = itFirst + 1; itk < itLast; ++itk) {
                Coordinate pk = geom[itk];
                double squaredDistance = CoordinateSplitter.calculateSquaredDistance(pk, pointA);
                if (!(squaredDistance > maxDistance)) continue;
                split = itk;
                maxDistance = squaredDistance;
            }
        }
        double ba_x = pointB.x - pointA.x;
        double ba_y = pointB.y - pointA.y;
        double ab_length_sqr = ba_x * ba_x + ba_y * ba_y;
        maxDistance *= ab_length_sqr;
        for (int itk = itFirst + 1; itk < itLast; ++itk) {
            Coordinate c = geom[itk];
            double distance_sqr = 0.0;
            double ca_x = c.x - pointA.x;
            double ca_y = c.y - pointA.y;
            double dot_ac_ab = ca_x * ba_x + ca_y * ba_y;
            if (dot_ac_ab <= 0.0) {
                distance_sqr = CoordinateSplitter.calculateSquaredDistance(c, pointA) * ab_length_sqr;
            } else if (dot_ac_ab >= ab_length_sqr) {
                distance_sqr = CoordinateSplitter.calculateSquaredDistance(c, pointB) * ab_length_sqr;
            } else {
                double s_numerator = ca_x * ba_y - ca_y * ba_x;
                distance_sqr = s_numerator * s_numerator;
            }
            if (!(distance_sqr > maxDistance)) continue;
            split = itk;
            maxDistance = distance_sqr;
        }
        return new SplitInPlace(geom, split);
    }

    private static double calculateSquaredDistance(Coordinate geomA, Coordinate geomB) {
        double distance = geomA.distance(geomB);
        return distance * distance;
    }

    public static class SplitInPlace {
        private Coordinate[] geom;
        private int split;

        public SplitInPlace(Coordinate[] geom, int split) {
            this.geom = geom;
            this.split = split;
        }

        public Coordinate[] getGeom() {
            return this.geom;
        }

        public int getSplit() {
            return this.split;
        }
    }
}

