/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package org.apache.sedona.snowflake.snowsql;

import org.junit.runner.notification.RunNotifier;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.junit.runners.model.InitializationError;

import java.lang.reflect.InvocationTargetException;
import java.sql.SQLException;


public class SnowTestRunner extends BlockJUnit4ClassRunner {

    private TestBase testObject;

    public SnowTestRunner(Class<TestBase> testClass) throws InitializationError, InstantiationException, IllegalAccessException, InvocationTargetException, SQLException {
        super(testClass);
        testObject = (TestBase) this.getTestClass().getOnlyConstructor().newInstance();
        testObject.init();
    }

    @Override
    protected Object createTest() {
        return testObject;
    }

    @Override
    public void run(RunNotifier notifier) {
        super.run(notifier);
        System.out.println("Closing SnowClient");
        testObject.tearDown();
    }
}
