/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sedona.common.utils;

import org.apache.sedona.common.utils.PointGeoHashEncoder;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;

public class GeometryGeoHashEncoder {
    private static GeometryFactory geometryFactory = new GeometryFactory();

    public static String calculate(Geometry geom, int precision) {
        Envelope gbox = geom.getEnvelope().getEnvelopeInternal();
        if (gbox.getMinX() < -180.0 || gbox.getMinY() < -90.0 || gbox.getMaxX() > 180.0 || gbox.getMaxY() > 90.0) {
            return null;
        }
        double lon = gbox.getMinX() + (gbox.getMaxX() - gbox.getMinX()) / 2.0;
        double lat = gbox.getMinY() + (gbox.getMaxY() - gbox.getMinY()) / 2.0;
        return PointGeoHashEncoder.calculateGeoHash(geometryFactory.createPoint(new Coordinate(lon, lat)), precision);
    }
}

