/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.spatial4j.shape.impl;

import org.locationtech.spatial4j.context.SpatialContext;
import org.locationtech.spatial4j.shape.Rectangle;

@Deprecated
public class Range {
    protected final double min;
    protected final double max;

    public static Range xRange(Rectangle rect, SpatialContext ctx) {
        if (ctx.isGeo()) {
            return new LongitudeRange(rect.getMinX(), rect.getMaxX());
        }
        return new Range(rect.getMinX(), rect.getMaxX());
    }

    public static Range yRange(Rectangle rect, SpatialContext ctx) {
        return new Range(rect.getMinY(), rect.getMaxY());
    }

    public Range(double min2, double max) {
        this.min = min2;
        this.max = max;
    }

    public double getMin() {
        return this.min;
    }

    public double getMax() {
        return this.max;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Range range = (Range)o;
        if (Double.compare(range.max, this.max) != 0) {
            return false;
        }
        return Double.compare(range.min, this.min) == 0;
    }

    public int hashCode() {
        long temp = this.min != 0.0 ? Double.doubleToLongBits(this.min) : 0L;
        int result = (int)(temp ^ temp >>> 32);
        temp = this.max != 0.0 ? Double.doubleToLongBits(this.max) : 0L;
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public String toString() {
        return "Range{" + this.min + " TO " + this.max + '}';
    }

    public double getWidth() {
        return this.max - this.min;
    }

    public boolean contains(double v) {
        return v >= this.min && v <= this.max;
    }

    public double getCenter() {
        return this.min + this.getWidth() / 2.0;
    }

    public Range expandTo(Range other) {
        assert (this.getClass() == other.getClass());
        return new Range(Math.min(this.min, other.min), Math.max(this.max, other.max));
    }

    public double deltaLen(Range other) {
        double min3 = Math.max(this.min, other.min);
        double max3 = Math.min(this.max, other.max);
        return max3 - min3;
    }

    @Deprecated
    public static class LongitudeRange
    extends Range {
        public static final LongitudeRange WORLD_180E180W = new LongitudeRange(-180.0, 180.0);

        public LongitudeRange(double min2, double max) {
            super(min2, max);
        }

        public LongitudeRange(Rectangle r) {
            super(r.getMinX(), r.getMaxX());
        }

        @Override
        public double getWidth() {
            double w = super.getWidth();
            if (w < 0.0) {
                w += 360.0;
            }
            return w;
        }

        @Override
        public boolean contains(double v) {
            if (!this.crossesDateline()) {
                return super.contains(v);
            }
            return v >= this.min || v <= this.max;
        }

        public boolean crossesDateline() {
            return this.min > this.max;
        }

        @Override
        public double getCenter() {
            double ctr = super.getCenter();
            if (ctr > 180.0) {
                ctr -= 360.0;
            }
            return ctr;
        }

        public double compareTo(LongitudeRange b) {
            return LongitudeRange.diff(this.getCenter(), b.getCenter());
        }

        private static double diff(double a, double b) {
            double diff = a - b;
            if (diff <= 180.0) {
                if (diff >= -180.0) {
                    return diff;
                }
                return diff + 360.0;
            }
            return diff - 360.0;
        }

        @Override
        public Range expandTo(Range other) {
            return this.expandTo((LongitudeRange)other);
        }

        public LongitudeRange expandTo(LongitudeRange other) {
            LongitudeRange newMax;
            LongitudeRange b;
            LongitudeRange a;
            if (this.compareTo(other) <= 0.0) {
                a = this;
                b = other;
            } else {
                a = other;
                b = this;
            }
            LongitudeRange newMin = b.contains(a.min) ? b : a;
            LongitudeRange longitudeRange = newMax = a.contains(b.max) ? a : b;
            if (newMin == newMax) {
                return newMin;
            }
            if (newMin == b && newMax == a) {
                return WORLD_180E180W;
            }
            return new LongitudeRange(newMin.min, newMax.max);
        }
    }
}

