/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.dataset.conv;

import java.util.StringTokenizer;
import ucar.nc2.Attribute;
import ucar.nc2.Variable;
import ucar.nc2.constants.AxisType;
import ucar.nc2.dataset.CoordSysBuilder;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.util.CancelTask;

public class MADISStation
extends CoordSysBuilder {
    public MADISStation() {
        this.conventionName = "MADIS_Station_1.0";
    }

    @Override
    public void augmentDataset(NetcdfDataset ds, CancelTask cancelTask) {
        String timeVars = ds.findAttValueIgnoreCase(null, "timeVariables", "");
        StringTokenizer stoker = new StringTokenizer(timeVars, ", ");
        while (stoker.hasMoreTokens()) {
            String vname = stoker.nextToken();
            Variable v = ds.findVariable(vname);
            if (v != null) {
                v.addAttribute(new Attribute("_CoordinateAxisType", AxisType.Time.toString()));
                continue;
            }
            this.parseInfo.format(" cant find time variable %s%n", vname);
        }
        String locVars = ds.findAttValueIgnoreCase(null, "stationLocationVariables", "");
        stoker = new StringTokenizer(locVars, ", ");
        int count = 0;
        while (stoker.hasMoreTokens()) {
            String vname = stoker.nextToken();
            Variable v = ds.findVariable(vname);
            if (v != null) {
                AxisType atype = count == 0 ? AxisType.Lat : (count == 1 ? AxisType.Lon : AxisType.Height);
                v.addAttribute(new Attribute("_CoordinateAxisType", atype.toString()));
            } else {
                this.parseInfo.format(" cant find time variable %s%n", vname);
            }
            ++count;
        }
    }
}

