/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.swagger.generator.pojo;

import com.fasterxml.jackson.databind.JavaType;
import io.swagger.converter.ModelConverters;
import io.swagger.models.Model;
import io.swagger.models.ModelImpl;
import io.swagger.models.RefModel;
import io.swagger.models.Swagger;
import io.swagger.models.parameters.BodyParameter;
import io.swagger.models.parameters.Parameter;
import io.swagger.models.properties.Property;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.servicecomb.swagger.SwaggerUtils;
import org.apache.servicecomb.swagger.generator.ParameterGenerator;
import org.apache.servicecomb.swagger.generator.core.AbstractOperationGenerator;
import org.apache.servicecomb.swagger.generator.core.AbstractSwaggerGenerator;
import org.apache.servicecomb.swagger.generator.core.model.HttpParameterType;
import org.apache.servicecomb.swagger.generator.core.utils.MethodUtils;

public class PojoOperationGenerator
extends AbstractOperationGenerator {
    protected ModelImpl bodyModel;
    protected BodyParameter bodyParameter;

    public PojoOperationGenerator(AbstractSwaggerGenerator swaggerGenerator, Method method) {
        super(swaggerGenerator, method);
    }

    @Override
    protected void initMethodParameterGenerators(Map<String, List<Annotation>> methodAnnotationMap) {
        super.initMethodParameterGenerators(methodAnnotationMap);
        this.tryWrapParametersToBody();
    }

    private void tryWrapParametersToBody() {
        List<ParameterGenerator> bodyFields = this.parameterGenerators.stream().filter(pg -> pg.getHttpParameterType() == null).collect(Collectors.toList());
        if (bodyFields.isEmpty()) {
            return;
        }
        if (bodyFields.size() == 1 && SwaggerUtils.isBean((Type)((ParameterGenerator)bodyFields.get(0)).getGenericType())) {
            ParameterGenerator parameterGenerator = bodyFields.get(0);
            parameterGenerator.setHttpParameterType(HttpParameterType.BODY);
            return;
        }
        this.wrapParametersToBody(bodyFields);
    }

    private void wrapParametersToBody(List<ParameterGenerator> bodyFields) {
        String simpleRef = MethodUtils.findSwaggerMethodName(this.method) + "Body";
        this.bodyModel = new ModelImpl();
        this.bodyModel.setType("object");
        for (ParameterGenerator parameterGenerator : bodyFields) {
            parameterGenerator.setHttpParameterType(HttpParameterType.BODY);
            this.scanMethodParameter(parameterGenerator);
            Property property = ModelConverters.getInstance().readAsProperty((Type)parameterGenerator.getGenericType());
            property.setDescription(parameterGenerator.getGeneratedParameter().getDescription());
            this.bodyModel.addProperty(parameterGenerator.getParameterName(), property);
            parameterGenerator.setHttpParameterType(null);
        }
        this.swagger.addDefinition(simpleRef, (Model)this.bodyModel);
        RefModel refModel = new RefModel();
        refModel.setReference("#/definitions/" + simpleRef);
        this.bodyParameter = new BodyParameter();
        this.bodyParameter.name(simpleRef);
        this.bodyParameter.setSchema((Model)refModel);
        this.bodyParameter.setName(this.parameterGenerators.size() == 1 ? ((ParameterGenerator)this.parameterGenerators.get(0)).getParameterName() : simpleRef);
        ArrayList<ParameterGenerator> newParameterGenerators = new ArrayList<ParameterGenerator>();
        newParameterGenerators.add(new ParameterGenerator(this.bodyParameter.getName(), Collections.emptyList(), null, HttpParameterType.BODY, (Parameter)this.bodyParameter));
        this.parameterGenerators.stream().filter(p -> p.getHttpParameterType() != null).forEach(newParameterGenerators::add);
        this.parameterGenerators = newParameterGenerators;
    }

    private boolean isWrapBody(Object parameter) {
        return parameter != null && parameter == this.bodyParameter;
    }

    @Override
    protected void fillParameter(Swagger swagger, Parameter parameter, String parameterName, JavaType type, List<Annotation> annotations) {
        if (this.isWrapBody(parameter)) {
            return;
        }
        super.fillParameter(swagger, parameter, parameterName, type, annotations);
    }

    @Override
    protected Parameter createParameter(ParameterGenerator parameterGenerator) {
        if (this.isWrapBody(parameterGenerator.getGeneratedParameter())) {
            return this.bodyParameter;
        }
        return super.createParameter(parameterGenerator);
    }

    @Override
    public void correctOperation() {
        this.correctPath();
        this.correctHttpMethod();
        super.correctOperation();
    }

    protected void correctPath() {
        if (StringUtils.isEmpty((CharSequence)this.path)) {
            this.path = "/" + this.getOperationId();
        }
    }

    protected void correctHttpMethod() {
        if (StringUtils.isEmpty((CharSequence)this.httpMethod)) {
            this.setHttpMethod("POST");
        }
    }
}

