/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.jms.util;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import org.apache.cxf.transport.jms.util.ResourceCloser;

public class JndiHelper {
    private Properties environment;

    public JndiHelper(Properties environment) {
        this.environment = environment;
    }

    protected Context createInitialContext() throws NamingException {
        Hashtable<String, String> icEnv = new Hashtable<String, String>(this.environment.size());
        Enumeration<?> en = this.environment.propertyNames();
        while (en.hasMoreElements()) {
            String key = (String)en.nextElement();
            Object value = this.environment.getProperty(key);
            if (value == null) {
                value = this.environment.get(key);
            }
            icEnv.put(key, (String)value);
        }
        return new InitialContext(icEnv);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T lookup(String name, Class<T> requiredType) throws NamingException {
        Context ctx = this.createInitialContext();
        try {
            Object located = ctx.lookup(name);
            if (located == null) {
                throw new NameNotFoundException("JNDI object with [" + name + "] not found");
            }
            Object object = located;
            return (T)object;
        }
        finally {
            ResourceCloser.close(ctx);
        }
    }
}

